/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.LoadException;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SettingsPanelHolder;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesPresetEditor;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoscopeFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class CoordinatesSettingsPanel
extends JPanel
implements SettingsPanel {
    private KaryoPanel karyoPanel;
    private CoordinatesPresets coordinatesPresets;
    private JButton fileButton;
    private JButton originalButton;
    private JButton[] presetButtons;
    private ViewFrame frame = null;

    public void setKaryoPanel(KaryoPanel karyoPanel) {
        this.karyoPanel = karyoPanel;
    }

    public KaryoPanel getKaryoPanel() {
        return this.karyoPanel;
    }

    public void setCoordinatesPresets(CoordinatesPresets coordinatesPresets) {
        this.coordinatesPresets = coordinatesPresets;
    }

    public CoordinatesPresets getCoordinatesPresets() {
        return this.coordinatesPresets;
    }

    public CoordinatesSettingsPanel(KaryoPanel karyoPanel, CoordinatesPresets coordinatesPresets, ViewFrame viewFrame) {
        this.setKaryoPanel(karyoPanel);
        this.setCoordinatesPresets(coordinatesPresets);
        this.setFrame(viewFrame);
        this.configureWidgets();
        this.addWidgets();
    }

    public void setEnabled(boolean bl) {
        this.fileButton.setEnabled(bl);
        this.originalButton.setEnabled(bl);
        for (int i = 0; i < this.presetButtons.length; ++i) {
            this.presetButtons[i].setEnabled(bl);
        }
    }

    public void setFrame(ViewFrame viewFrame) {
        this.frame = viewFrame;
    }

    public ViewFrame getFrame() {
        return this.frame;
    }

    private void addWidgets() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)this.originalButton, gridBagConstraints);
        JPanel jPanel = new JPanel();
        for (int i = 0; i < this.presetButtons.length; ++i) {
            jPanel.add(this.presetButtons[i]);
        }
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        gridBagConstraints.gridy = 1;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.fileButton, gridBagConstraints);
    }

    private void configureWidgets() {
        this.originalButton = new JButton("Extract from Cdt");
        this.originalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordinatesSettingsPanel.this.karyoPanel.useOriginal();
            }
        });
        final CoordinatesPresets coordinatesPresets = this.getCoordinatesPresets();
        int n = coordinatesPresets.getNumPresets();
        this.presetButtons = new JButton[n];
        int n2 = 0;
        while (n2 < n) {
            JButton jButton = new JButton(coordinatesPresets.getPresetNames()[n2]);
            final int n3 = n2++;
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CoordinatesSettingsPanel.this.switchFileset(coordinatesPresets.getFileSet(n3));
                }
            });
            this.presetButtons[n3] = jButton;
        }
        this.fileButton = new JButton("Edit Presets...");
        this.fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CoordinatesPresetEditor coordinatesPresetEditor = KaryoscopeFactory.getCoordinatesPresetsEditor();
                JDialog jDialog = new JDialog((Frame)CoordinatesSettingsPanel.this.getFrame(), "Edit Coordinates Presets");
                SettingsPanelHolder settingsPanelHolder = new SettingsPanelHolder((Window)jDialog, CoordinatesSettingsPanel.this.getFrame().getApp().getGlobalConfig().getRoot());
                settingsPanelHolder.addSettingsPanel((SettingsPanel)coordinatesPresetEditor);
                jDialog.getContentPane().add((Component)settingsPanelHolder);
                jDialog.setModal(true);
                jDialog.pack();
                ((Component)jDialog).setVisible(true);
                CoordinatesSettingsPanel.this.configureWidgets();
                CoordinatesSettingsPanel.this.addWidgets();
                CoordinatesSettingsPanel.this.revalidate();
                CoordinatesSettingsPanel.this.repaint();
            }
        });
    }

    private void switchFileset(FileSet fileSet) {
        try {
            this.setEnabled(false);
            this.karyoPanel.getGenome(fileSet);
        }
        catch (LoadException loadException) {
            this.setEnabled(true);
            LogBuffer.println((String)("CoordinatesSettingsPanel got error" + loadException.toString()));
            JOptionPane.showMessageDialog((Component)this.getFrame(), loadException.toString(), "Load Error", 0);
        }
    }

    public void synchronizeTo() {
    }

    public void synchronizeFrom() {
    }
}

