/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.plugin.karyoview.Chromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.CircularChromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoParseException;
import edu.stanford.genetics.treeview.plugin.karyoview.LinearChromosome;

class Genome {
    private ChromosomeLocus[] loci;
    private Chromosome[] chromosomes;
    private boolean structValid;
    private FileSet fileSet = null;

    public void addLocus(ChromosomeLocus chromosomeLocus) {
        this.loci[chromosomeLocus.getCdtIndex()] = chromosomeLocus;
        this.setStructValid(false);
    }

    public ChromosomeLocus getLocus(int n) {
        return this.loci[n];
    }

    public int getNumLoci() {
        return this.loci.length;
    }

    public Chromosome getChromosome(int n) {
        if (!this.isStructValid()) {
            this.buildTree();
        }
        return this.chromosomes[n - 1];
    }

    public int getNonemptyCount() {
        int n = 0;
        for (int i = 1; i < this.getMaxChromosome(); ++i) {
            Chromosome chromosome = this.getChromosome(i);
            if (chromosome.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public double getMaxPosition() {
        if (!this.isStructValid()) {
            this.buildTree();
        }
        double d = -1.0;
        for (int i = 0; i < this.chromosomes.length; ++i) {
            double d2 = this.chromosomes[i].getMaxPosition();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public int getMaxChromosome() {
        if (!this.isStructValid()) {
            this.buildTree();
        }
        return this.chromosomes.length;
    }

    private void setStructValid(boolean bl) {
        this.structValid = bl;
    }

    private boolean isStructValid() {
        return this.structValid;
    }

    public void setFileSet(FileSet fileSet) {
        this.fileSet = fileSet;
    }

    public FileSet getFileSet() {
        return this.fileSet;
    }

    Genome(int n) {
        this.loci = new ChromosomeLocus[n];
        this.structValid = false;
    }

    public Genome(DataModel dataModel) {
        this(dataModel.getDataMatrix().getNumRow());
        HeaderInfo headerInfo = dataModel.getGeneHeaderInfo();
        int n = headerInfo.getIndex("CHROMOSOME");
        int n2 = headerInfo.getIndex("ARM");
        int n3 = headerInfo.getIndex("POSITION");
        int n4 = headerInfo.getIndex("YORF");
        int n5 = dataModel.getDataMatrix().getNumRow();
        this.fileSet = dataModel.getFileSet();
        double[] dArray = new double[3];
        for (int i = 0; i < n5; ++i) {
            ChromosomeLocus chromosomeLocus = null;
            try {
                if (n != -1) {
                    dArray[0] = Genome.makeDouble(headerInfo.getHeader(i)[n]);
                    dArray[1] = Genome.makeArm(headerInfo.getHeader(i)[n2]);
                    dArray[2] = Genome.makeDouble(headerInfo.getHeader(i)[n3]);
                } else {
                    Genome.parseYorf(headerInfo.getHeader(i)[n4], dArray);
                }
                int n6 = (int)dArray[0];
                int n7 = (int)dArray[1];
                double d = dArray[2];
                chromosomeLocus = new ChromosomeLocus(n6, n7, d, i);
            }
            catch (KaryoParseException karyoParseException) {
                chromosomeLocus = new ChromosomeLocus(-1, -1, -1.0, i);
            }
            this.addLocus(chromosomeLocus);
        }
    }

    private static final double makeArm(String string) throws KaryoParseException {
        try {
            return Genome.makeDouble(string);
        }
        catch (KaryoParseException karyoParseException) {
            if (string.indexOf(114) >= 0) {
                return 2.0;
            }
            if (string.indexOf(82) >= 0) {
                return 2.0;
            }
            if (string.indexOf(108) >= 0) {
                return 1.0;
            }
            if (string.indexOf(76) >= 0) {
                return 1.0;
            }
            if (string.indexOf(99) >= 0) {
                return 3.0;
            }
            if (string.indexOf(67) >= 0) {
                return 3.0;
            }
            throw karyoParseException;
        }
    }

    private static final double makeDouble(String string) throws KaryoParseException {
        try {
            Double d = new Double(string);
            return d;
        }
        catch (Exception exception) {
            throw new KaryoParseException(exception.getMessage());
        }
    }

    private static final void parseYorf(String string, double[] dArray) throws KaryoParseException {
        try {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            char c = string.charAt(1);
            switch (string.charAt(1)) {
                case 'A': {
                    dArray[0] = 1.0;
                    break;
                }
                case 'B': {
                    dArray[0] = 2.0;
                    break;
                }
                case 'C': {
                    dArray[0] = 3.0;
                    break;
                }
                case 'D': {
                    dArray[0] = 4.0;
                    break;
                }
                case 'E': {
                    dArray[0] = 5.0;
                    break;
                }
                case 'F': {
                    dArray[0] = 6.0;
                    break;
                }
                case 'G': {
                    dArray[0] = 7.0;
                    break;
                }
                case 'H': {
                    dArray[0] = 8.0;
                    break;
                }
                case 'I': {
                    dArray[0] = 9.0;
                    break;
                }
                case 'J': {
                    dArray[0] = 10.0;
                    break;
                }
                case 'K': {
                    dArray[0] = 11.0;
                    break;
                }
                case 'L': {
                    dArray[0] = 12.0;
                    break;
                }
                case 'M': {
                    dArray[0] = 13.0;
                    break;
                }
                case 'N': {
                    dArray[0] = 14.0;
                    break;
                }
                case 'O': {
                    dArray[0] = 15.0;
                    break;
                }
                case 'P': {
                    dArray[0] = 16.0;
                }
            }
            switch (string.charAt(2)) {
                case 'L': {
                    dArray[1] = 1.0;
                    break;
                }
                case 'R': {
                    dArray[1] = 2.0;
                }
            }
            dArray[2] = Genome.makeDouble(string.substring(3, 6));
        }
        catch (Exception exception) {
            throw new KaryoParseException(exception.getMessage());
        }
    }

    private synchronized void buildTree() {
        if (this.isStructValid()) {
            return;
        }
        this.allocateDataStructure();
        this.loadDataStructure();
        this.setStructValid(true);
    }

    private void loadDataStructure() {
        for (int i = 0; i < this.loci.length; ++i) {
            ChromosomeLocus chromosomeLocus = this.loci[i];
            if (chromosomeLocus.getChromosome() <= 0) continue;
            this.chromosomes[chromosomeLocus.getChromosome() - 1].insertLocus(chromosomeLocus);
        }
    }

    private void allocateDataStructure() {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.loci.length; ++i) {
            if (this.loci[i] == null || this.loci[i].getChromosome() <= n2) continue;
            n2 = this.loci[i].getChromosome();
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = 0;
            nArray2[n] = 0;
            nArray3[n] = 0;
        }
        for (n = 0; n < this.loci.length; ++n) {
            int n3 = this.loci[n].getChromosome();
            int n4 = this.loci[n].getArm();
            if (n4 == 1) {
                int n5 = n3 - 1;
                nArray[n5] = nArray[n5] + 1;
            }
            if (n4 == 2) {
                int n6 = n3 - 1;
                nArray2[n6] = nArray2[n6] + 1;
            }
            if (n4 != 3) continue;
            int n7 = n3 - 1;
            nArray3[n7] = nArray3[n7] + 1;
        }
        this.chromosomes = new Chromosome[n2];
        for (n = 0; n < n2; ++n) {
            this.chromosomes[n] = nArray3[n] != 0 ? new CircularChromosome(nArray3[n]) : new LinearChromosome(nArray[n], nArray2[n]);
        }
    }
}

