/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.DataMatrix;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.plugin.karyoview.Averager;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;

abstract class GroupAverager
extends Averager {
    GroupAverager() {
    }

    protected abstract ChromosomeLocus[] getContributors(ChromosomeLocus var1);

    protected abstract String getPre();

    public String[] getDescription(ChromosomeLocus chromosomeLocus, int n) {
        HeaderInfo headerInfo = this.karyoView.getGeneInfo();
        if (chromosomeLocus == null) {
            this.message[0] = "Locus is null";
            this.message[1] = "";
        } else {
            ChromosomeLocus[] chromosomeLocusArray = this.getContributors(chromosomeLocus);
            this.message[0] = this.getPre() + " locus " + headerInfo.getHeader(chromosomeLocus.getCdtIndex(), "YORF");
            this.message[1] = "Mean of " + chromosomeLocusArray.length + " loci: " + this.summarizeYorf(chromosomeLocusArray);
        }
        return this.message;
    }

    private String summarizeYorf(ChromosomeLocus[] chromosomeLocusArray) {
        HeaderInfo headerInfo = this.karyoView.getGeneInfo();
        if (chromosomeLocusArray.length == 0) {
            return "No loci contribute";
        }
        try {
            if (chromosomeLocusArray.length < 101) {
                String string = headerInfo.getHeader(chromosomeLocusArray[0].getCdtIndex(), "YORF");
                for (int i = 1; i < chromosomeLocusArray.length; ++i) {
                    if (chromosomeLocusArray[i] == null) continue;
                    string = string + ", " + headerInfo.getHeader(chromosomeLocusArray[i].getCdtIndex(), "YORF");
                }
                return string;
            }
            return "more than 100 loci contribute";
        }
        catch (Exception exception) {
            LogBuffer.println((String)("failed to summarize loci in GroupAverager!: " + exception.toString()));
            return "failed to summarize loci!: " + exception.toString();
        }
    }

    public double getValue(ChromosomeLocus chromosomeLocus, int n) {
        if (chromosomeLocus == null) {
            return 0.0;
        }
        int n2 = chromosomeLocus.getCdtIndex();
        ChromosomeLocus[] chromosomeLocusArray = this.getContributors(chromosomeLocus);
        double d = 0.0;
        int n3 = 0;
        DataMatrix dataMatrix = this.karyoView.getDataMatrix();
        int n4 = this.karyoView.getNumCol();
        for (int i = 0; i < chromosomeLocusArray.length; ++i) {
            int n5;
            if (chromosomeLocusArray[i] == null || (n5 = chromosomeLocusArray[i].getCdtIndex()) == -1) continue;
            d += dataMatrix.getValue(n, n5);
            ++n3;
        }
        return d / (double)n3;
    }

    protected boolean isNodata(ChromosomeLocus chromosomeLocus) {
        DataMatrix dataMatrix = this.karyoView.getDataMatrix();
        int n = this.karyoView.getNumCol();
        try {
            double d = dataMatrix.getValue(this.karyoView.getCurrentCol(), chromosomeLocus.getCdtIndex());
            return this.karyoView.getNodata() == d;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return true;
        }
    }

    protected double getDist(ChromosomeLocus chromosomeLocus, ChromosomeLocus chromosomeLocus2) {
        int n;
        int n2 = chromosomeLocus.getArm();
        if (n2 == (n = chromosomeLocus2.getArm())) {
            return Math.abs(chromosomeLocus.getPosition() - chromosomeLocus2.getPosition());
        }
        return Math.abs(chromosomeLocus.getPosition() + chromosomeLocus2.getPosition());
    }

    protected double square(double d) {
        return d * d;
    }
}

