/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.karyoview.Chromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.Genome;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorSet;
import edu.stanford.genetics.treeview.plugin.karyoview.LinearChromosome;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public class KaryoDrawer
extends Observable
implements Observer {
    private Genome genome;
    private KaryoColorSet karyoColorSet = new KaryoColorSet("KaryoDrawerColorSet");
    private TreeSelectionI geneSelection;
    private double nodata;
    private int height = 0;
    private int width = 0;
    private double pixelPerMap;
    private double pixelPerVal;
    private int defaultIconSize = 2;
    private int[] iconSizes = new int[]{1, 3, 5, 7};
    private int defaultIconType = 2;
    private String[] iconTypes = new String[]{"None", "Circle", "Disc"};
    private double defaultLinesBase = 2.0;
    private int defaultLinesAbove = 0;
    private int defaultLinesMax = 5;
    private int defaultLinesBelow = 0;
    private int defaultDrawBars = 1;
    private int defaultDrawLines = 0;
    private double[] mapValues;
    private int border = 5;
    private int yborder = 0;
    private ConfigNode configNode = new DummyConfigNode("KaryoDrawer");

    public void setGenome(Genome genome) {
        this.genome = genome;
        this.setChanged();
    }

    public Genome getGenome() {
        return this.genome;
    }

    private void setKaryoColorSet(KaryoColorSet karyoColorSet) {
        this.karyoColorSet = karyoColorSet;
    }

    public KaryoColorSet getKaryoColorSet() {
        return this.karyoColorSet;
    }

    public void setGeneSelection(TreeSelectionI treeSelectionI) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver((Observer)this);
        }
        this.setChanged();
        this.geneSelection = treeSelectionI;
        if (this.geneSelection != null) {
            this.geneSelection.addObserver((Observer)this);
        }
    }

    public TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    public void setNodata(double d) {
        this.nodata = d;
    }

    public double getNodata() {
        return this.nodata;
    }

    public void setHeight(int n) {
        if (this.height == n) {
            return;
        }
        this.height = n;
        this.setChanged();
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        if (this.width == n) {
            return;
        }
        this.width = n;
        this.setChanged();
    }

    public int getWidth() {
        return this.width;
    }

    public void setPixelPerMap(double d) {
        this.pixelPerMap = d;
        this.setChanged();
    }

    public double getPixelPerMap() {
        return this.pixelPerMap;
    }

    public void setPixelPerVal(double d) {
        this.pixelPerVal = d;
        this.setChanged();
    }

    public double getPixelPerVal() {
        return this.pixelPerVal;
    }

    public void setIconSize(int n) {
        this.configNode.setAttribute("iconSize", n, this.defaultIconSize);
        this.setChanged();
    }

    public int getIconSize() {
        return this.configNode.getAttribute("iconSize", this.defaultIconSize);
    }

    public int[] getIconSizes() {
        return this.iconSizes;
    }

    public void setIconType(int n) {
        this.configNode.setAttribute("iconType", n, this.defaultIconType);
        this.setChanged();
    }

    public int getIconType() {
        return this.configNode.getAttribute("iconType", this.defaultIconType);
    }

    public void setIconTypes(String[] stringArray) {
        this.iconTypes = stringArray;
    }

    public String[] getIconTypes() {
        return this.iconTypes;
    }

    public void setLinesBase(double d) {
        if (this.getLinesBase() == d) {
            return;
        }
        this.configNode.setAttribute("linesBase", d, this.defaultLinesBase);
        this.setChanged();
    }

    public double getLinesBase() {
        return this.configNode.getAttribute("linesBase", this.defaultLinesBase);
    }

    public void setLinesAbove(boolean bl) {
        if (this.getLinesAbove() == bl) {
            return;
        }
        int n = bl ? 1 : 0;
        this.configNode.setAttribute("linesAbove", n, this.defaultLinesAbove);
        this.setChanged();
    }

    public boolean getLinesAbove() {
        return this.configNode.getAttribute("linesAbove", this.defaultLinesAbove) == 1;
    }

    public void setLinesMax(int n) {
        if (this.getLinesMax() == n) {
            return;
        }
        this.configNode.setAttribute("linesMax", n, this.defaultLinesMax);
        this.setChanged();
    }

    public int getLinesMax() {
        return this.configNode.getAttribute("linesMax", this.defaultLinesMax);
    }

    public void setLinesBelow(boolean bl) {
        if (bl == this.getLinesBelow()) {
            return;
        }
        int n = bl ? 1 : 0;
        this.configNode.setAttribute("linesBelow", n, this.defaultLinesBelow);
        this.setChanged();
    }

    public boolean getLinesBelow() {
        return this.configNode.getAttribute("linesBelow", this.defaultLinesBelow) == 1;
    }

    public boolean getBarChart() {
        return this.configNode.getAttribute("drawBars", this.defaultDrawBars) == 1;
    }

    public void setBarChart(boolean bl) {
        int n = bl ? 1 : 0;
        this.configNode.setAttribute("drawBars", n, this.defaultDrawBars);
        this.setChanged();
    }

    public boolean getLineChart() {
        return this.configNode.getAttribute("drawLines", this.defaultDrawLines) == 1;
    }

    public void setLineChart(boolean bl) {
        int n = bl ? 1 : 0;
        this.configNode.setAttribute("drawLines", n, this.defaultDrawLines);
        this.setChanged();
    }

    public void setMapValue(int n, double d) {
        if (n < 0) {
            return;
        }
        this.setChanged();
        this.mapValues[n] = d;
    }

    public void setMapValue(ChromosomeLocus chromosomeLocus, double d) {
        this.setMapValue(chromosomeLocus.getCdtIndex(), d);
    }

    public double getMapValue(int n) {
        return this.mapValues[n];
    }

    public void cleanup() {
        this.geneSelection = null;
        this.mapValues = null;
    }

    public void update(Observable observable, Object object) {
        if (observable == this.geneSelection) {
            this.setChanged();
            this.notifyObservers();
        } else {
            LogBuffer.println((String)("KaryoView got weird update from " + observable));
        }
    }

    public KaryoDrawer(Genome genome, TreeSelectionI treeSelectionI, double d) {
        this.mapValues = new double[treeSelectionI.getNumIndexes()];
        this.setGenome(genome);
        this.setGeneSelection(treeSelectionI);
        this.setNodata(d);
        this.setHeight(100);
        this.setWidth(100);
        this.autoScale();
    }

    public void autoScale() {
        Genome genome = this.getGenome();
        int n = genome.getMaxChromosome();
        if (n == 0) {
            return;
        }
        Dimension dimension = new Dimension(this.width, this.height / n);
        int n2 = -1;
        for (int i = 1; i <= n; ++i) {
            if (genome.getChromosome(i).isEmpty() || !this.hasData(genome.getChromosome(i))) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            this.setPixelPerMap(1.0);
            this.setPixelPerVal(1.0);
        } else {
            double d = this.getOptPpm(genome.getChromosome(n2), dimension);
            double d2 = this.getOptPpv(genome.getChromosome(n2), dimension);
            for (int i = n2 + 1; i <= n; ++i) {
                double d3 = this.getOptPpm(genome.getChromosome(i), dimension);
                double d4 = this.getOptPpv(genome.getChromosome(i), dimension);
                if (d4 == 0.0 || d3 == 0.0) continue;
                if (d3 < d) {
                    d = d3;
                }
                if (!(d4 < d2)) continue;
                d2 = d4;
            }
            this.setPixelPerMap(d);
            this.setPixelPerVal(d2);
        }
    }

    private double getOptPpv(Chromosome chromosome, Dimension dimension) {
        double d;
        double d2 = 0.0;
        if (chromosome.getMaxPosition(3) == 0.0 && (d = this.getMaxAbsVal(chromosome.getLeftEnd())) != 0.0) {
            d2 = (double)(dimension.height - 2 * this.yborder) / (1.5 * d);
        }
        return d2;
    }

    private boolean hasData(Chromosome chromosome) {
        if (chromosome.getMaxPosition(3) == 0.0) {
            ChromosomeLocus chromosomeLocus;
            ChromosomeLocus chromosomeLocus2 = chromosomeLocus = chromosome.getLeftEnd();
            do {
                double d;
                int n;
                if ((n = chromosomeLocus2.getCdtIndex()) < 0 || (d = this.mapValues[n]) == this.nodata) continue;
                return true;
            } while ((chromosomeLocus2 = chromosomeLocus2.getRight()) != chromosomeLocus && chromosomeLocus2 != null);
        }
        return false;
    }

    private double getOptPpm(Chromosome chromosome, Dimension dimension) {
        double d = 0.0;
        if (chromosome.getMaxPosition(3) == 0.0) {
            double d2 = chromosome.getMaxPosition();
            d = (double)(dimension.width - 2 * this.border) / (2.0 * d2);
        }
        return d;
    }

    private double getMaxAbsVal(ChromosomeLocus chromosomeLocus) {
        double d = 0.0;
        if (chromosomeLocus == null) {
            return d;
        }
        ChromosomeLocus chromosomeLocus2 = chromosomeLocus;
        do {
            double d2;
            int n;
            if ((n = chromosomeLocus2.getCdtIndex()) < 0 || (d2 = this.mapValues[n]) == this.nodata || !((d2 = Math.abs(d2)) > d)) continue;
            d = d2;
        } while ((chromosomeLocus2 = chromosomeLocus2.getRight()) != chromosomeLocus && chromosomeLocus2 != null);
        return d;
    }

    private double getSumAbsVal(ChromosomeLocus chromosomeLocus) {
        double d = 0.0;
        if (chromosomeLocus == null) {
            return d;
        }
        ChromosomeLocus chromosomeLocus2 = chromosomeLocus;
        do {
            double d2;
            int n;
            if ((n = chromosomeLocus2.getCdtIndex()) < 0 || (d2 = this.mapValues[n]) == this.nodata) continue;
            d2 = Math.abs(d2);
            d += d2;
        } while ((chromosomeLocus2 = chromosomeLocus2.getRight()) != chromosomeLocus && chromosomeLocus2 != null);
        return d;
    }

    private int getCount(ChromosomeLocus chromosomeLocus) {
        int n = 0;
        if (chromosomeLocus == null) {
            return n;
        }
        ChromosomeLocus chromosomeLocus2 = chromosomeLocus;
        do {
            double d;
            int n2;
            if ((n2 = chromosomeLocus2.getCdtIndex()) < 0 || (d = this.mapValues[n2]) == this.nodata) continue;
            ++n;
        } while ((chromosomeLocus2 = chromosomeLocus2.getRight()) != chromosomeLocus && chromosomeLocus2 != null);
        return n;
    }

    private int getLinearPosition(ChromosomeLocus chromosomeLocus, int n) {
        if (chromosomeLocus == null) {
            return 0;
        }
        int n2 = chromosomeLocus.getArm();
        double d = chromosomeLocus.getPosition();
        int n3 = n2 == 1 ? n - (int)(d * this.getPixelPerMap()) : n + (int)(d * this.getPixelPerMap());
        return n3;
    }

    public int getFarthestEndDistance(Chromosome chromosome) {
        int n = 0;
        if (chromosome.getMaxPosition(3) == 0.0) {
            double d = chromosome.getMaxPosition();
            n = (int)(d * this.getPixelPerMap());
        }
        return n;
    }

    public void paintChromosome(Graphics graphics, LinearChromosome linearChromosome, Rectangle rectangle) {
        double d;
        int n;
        int n2 = rectangle.width / 2 + rectangle.x;
        int n3 = rectangle.height / 2 + rectangle.y;
        ChromosomeLocus chromosomeLocus = linearChromosome.getLeftEnd();
        ChromosomeLocus chromosomeLocus2 = linearChromosome.getRightEnd();
        int n4 = this.getLinearPosition(chromosomeLocus, n2);
        int n5 = this.getLinearPosition(chromosomeLocus2, n2);
        graphics.setColor(this.getKaryoColorSet().getColor("Genome"));
        graphics.drawLine(n4, n3, n5, n3);
        if (this.getLinesAbove() || this.getLinesBelow()) {
            int n6 = 2;
            n = n6 + this.getLinesMax();
            double d2 = this.getLinesBase();
            double d3 = Math.log(d2);
            d = this.getPixelPerVal();
            double d4 = Math.log(n6++) / d3;
            int n7 = (int)(d * d4);
            int n8 = 0;
            graphics.setColor(this.getKaryoColorSet().getColor("Line"));
            while (n6 <= n && n8 + 1 < n7) {
                if (this.getLinesAbove()) {
                    graphics.drawLine(n4, n3 - n7, n5, n3 - n7);
                }
                if (this.getLinesBelow()) {
                    graphics.drawLine(n4, n3 + n7, n5, n3 + n7);
                }
                n8 = n7;
                d4 = Math.log(n6++) / d3;
                n7 = (int)(d * d4);
            }
        }
        n = 0;
        int n9 = 0;
        ChromosomeLocus chromosomeLocus3 = null;
        for (ChromosomeLocus chromosomeLocus4 = linearChromosome.getLeftEnd(); chromosomeLocus4 != null; chromosomeLocus4 = chromosomeLocus4.getRight()) {
            int n10 = chromosomeLocus4.getCdtIndex();
            if (n10 < 0) continue;
            int n11 = this.getLinearPosition(chromosomeLocus4, n2);
            if (this.geneSelection != null && this.geneSelection.isIndexSelected(n10)) {
                graphics.setColor(this.getKaryoColorSet().getColor("Highlight"));
                int n12 = this.iconSizes[this.getIconSize()];
                int n13 = (n12 - 1) / 2;
                switch (this.getIconType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        graphics.fillOval(n11 - n13, n3 - n13, n12, n12);
                        break;
                    }
                    case 2: {
                        graphics.drawOval(n11 - n13, n3 - n13, n12, n12);
                    }
                }
            }
            d = this.mapValues[n10];
            int n14 = n3;
            if (d == this.nodata) continue;
            n14 -= (int)(d * this.getPixelPerVal());
            if (this.getBarChart()) {
                if (d > 0.0) {
                    graphics.setColor(this.getKaryoColorSet().getColor("Up"));
                } else {
                    graphics.setColor(this.getKaryoColorSet().getColor("Down"));
                }
                graphics.drawLine(n11, n3, n11, n14);
            }
            if (!this.getLineChart()) continue;
            if (chromosomeLocus3 != null) {
                graphics.setColor(this.getKaryoColorSet().getColor("Line"));
                graphics.drawLine(n, n9, n11, n14);
            }
            chromosomeLocus3 = chromosomeLocus4;
            n = n11;
            n9 = n14;
        }
        graphics.setColor(Color.blue);
        graphics.drawOval(n2 - 3, n3 - 3, 5, 5);
    }

    public int getStartingY(int n) {
        int n2 = this.genome.getMaxChromosome();
        if (n == n2) {
            return this.getHeight();
        }
        if (n2 == 0) {
            return 0;
        }
        return n * this.getHeight() / n2;
    }

    public int minVisibleChromosome(Rectangle rectangle) {
        int n = 0;
        int n2 = this.genome.getMaxChromosome();
        while (this.getStartingY(n) < rectangle.y && ++n != n2) {
        }
        if (n < 2) {
            return 1;
        }
        return n;
    }

    public int maxVisibleChromosome(Rectangle rectangle) {
        int n = 1;
        int n2 = this.genome.getMaxChromosome();
        while (this.getStartingY(n) < rectangle.y + rectangle.height && ++n != n2) {
        }
        if (n > n2) {
            n = n2;
        }
        return n;
    }

    public void paintBackground(Graphics graphics, Rectangle rectangle) {
        if (rectangle != null) {
            graphics.setColor(this.getKaryoColorSet().getColor("Background"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        this.paintBackground(graphics, rectangle);
        int n = this.genome.getMaxChromosome();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (this.getStartingY(n2) < rectangle.y && ++n2 != n) {
        }
        int n3 = n2;
        while (this.getStartingY(n3) < rectangle.y + rectangle.height && ++n3 != n) {
        }
        if (n2 != 0) {
            --n2;
        }
        if (++n3 > n) {
            n3 = n;
        }
        Rectangle rectangle2 = new Rectangle();
        for (int i = n2; i < n3; ++i) {
            rectangle2.x = 0;
            rectangle2.y = this.getStartingY(i);
            rectangle2.width = this.getWidth();
            rectangle2.height = this.getStartingY(i + 1) - rectangle2.y;
            this.paintChromosome(graphics, this.genome.getChromosome(i + 1), rectangle2);
        }
    }

    public void paintChromosome(Graphics graphics, Chromosome chromosome, Rectangle rectangle) {
        if (chromosome.getType() == 1) {
            this.paintChromosome(graphics, (LinearChromosome)chromosome, rectangle);
        }
    }

    public ChromosomeLocus getClosest(Point point) {
        int n = this.genome.getMaxChromosome();
        for (int i = 1; i <= n; ++i) {
            if (point.y >= this.getStartingY(i)) continue;
            return this.getClosest(this.genome.getChromosome(i), point);
        }
        return null;
    }

    public ChromosomeLocus getClosest(Chromosome chromosome, Point point) {
        ChromosomeLocus chromosomeLocus;
        ChromosomeLocus chromosomeLocus2;
        if (chromosome == null) {
            return null;
        }
        ChromosomeLocus chromosomeLocus3 = chromosomeLocus2 = (chromosomeLocus = chromosome.getLeftEnd());
        double d = 100000.0 * this.getDistance(chromosomeLocus2, point);
        if (chromosomeLocus3 == null) {
            return null;
        }
        do {
            double d2;
            int n;
            if ((n = chromosomeLocus3.getCdtIndex()) < 0 || !((d2 = this.getDistance(chromosomeLocus3, point)) < d)) continue;
            d = d2;
            chromosomeLocus2 = chromosomeLocus3;
        } while ((chromosomeLocus3 = chromosomeLocus3.getRight()) != null && chromosomeLocus3 != chromosomeLocus);
        return chromosomeLocus2;
    }

    private double getDistance(ChromosomeLocus chromosomeLocus, Point point) {
        Point point2 = this.getBase(chromosomeLocus);
        if (point2 == null) {
            return 10.0;
        }
        return this.square(point2.x - point.x) + this.square(point2.y - point.y);
    }

    private double square(double d) {
        return d * d;
    }

    public Point getBase(ChromosomeLocus chromosomeLocus) {
        int n;
        if (this.genome == null || chromosomeLocus == null) {
            return null;
        }
        int n2 = this.genome.getChromosome(chromosomeLocus.getChromosome()).getType();
        int n3 = (this.getStartingY(chromosomeLocus.getChromosome() - 1) + this.getStartingY(chromosomeLocus.getChromosome())) / 2;
        int n4 = n = this.getWidth() / 2;
        int n5 = n3;
        if (n2 == 1) {
            int n6 = chromosomeLocus.getArm();
            double d = chromosomeLocus.getPosition();
            n4 = n6 == 1 ? n - (int)(d * this.getPixelPerMap()) : n + (int)(d * this.getPixelPerMap());
        }
        return new Point(n4, n5);
    }

    public Point getEnd(ChromosomeLocus chromosomeLocus) {
        int n = this.genome.getChromosome(chromosomeLocus.getChromosome()).getType();
        if (n == 1) {
            double d;
            Point point = this.getBase(chromosomeLocus);
            int n2 = chromosomeLocus.getCdtIndex();
            if (n2 >= 0 && (d = this.mapValues[n2]) != this.nodata) {
                point.y -= (int)(d * this.getPixelPerVal());
            }
            return point;
        }
        return new Point(0, 0);
    }

    public void bindConfig(ConfigNode configNode) {
        this.configNode = configNode;
        this.getKaryoColorSet().bindConfig(this.getFirst("KaryoColorSet"));
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    private ConfigNode getFirst(String string) {
        ConfigNode configNode = this.getConfigNode().fetchFirst(string);
        return configNode == null ? this.getConfigNode().create(string) : configNode;
    }
}

