/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.CancelableSettingsDialog;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.DragGridPanel;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LoadException;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.MessagePanel;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.ModelessSettingsDialog;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SwingWorker;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.UrlSettingsPanel;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.XmlConfig;
import edu.stanford.genetics.treeview.model.TVModel;
import edu.stanford.genetics.treeview.plugin.karyoview.BitmapKaryoViewExportPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesSettingsPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.DisplaySettingsPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.Genome;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoDrawer;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoView;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoViewParameterPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoscopeFactory;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class KaryoPanel
extends DragGridPanel
implements MainPanel {
    ProgressMonitor coordinatesMonitor;
    Timer coordinatesTimer;
    CoordinatesTask coordinatesTask;
    CoordinatesSettingsPanel coordinatesPanel = null;
    private ConfigNode configNode;
    private ViewFrame viewFrame;
    private boolean windowActive;
    private Genome startingGenome;
    private Genome genome;
    private KaryoDrawer karyoDrawer;
    private KaryoView karyoView;
    private KaryoViewParameterPanel parameterPanel;
    private MessagePanel statusPanel;
    private static ImageIcon karyoIcon = null;

    public KaryoPanel(DataModel dataModel, TreeSelectionI treeSelectionI, ViewFrame viewFrame, ConfigNode configNode) {
        super(2, 3);
        Object object;
        this.viewFrame = viewFrame;
        this.genome = this.startingGenome = new Genome(dataModel);
        this.bindConfig(configNode);
        this.karyoDrawer = new KaryoDrawer(this.genome, treeSelectionI, -1.0E7);
        this.karyoDrawer.bindConfig(this.getFirst("KaryoDrawer"));
        this.karyoView = new KaryoView(this.karyoDrawer, dataModel);
        this.karyoView.bindConfig(this.getFirst("KaryoView"));
        this.parameterPanel = new KaryoViewParameterPanel(this.karyoDrawer, this.karyoView, this);
        this.statusPanel = new MessagePanel("View Status");
        this.windowActive = true;
        this.setBorderWidth(2);
        this.setBorderHeight(2);
        this.setMinimumWidth(1);
        this.setMinimumHeight(1);
        this.setFocusWidth(1);
        this.setFocusHeight(1);
        this.setupViews();
        this.coordinatesTimer = new Timer(1000, new TimerListener());
        this.coordinatesTimer.stop();
        try {
            object = KaryoscopeFactory.getCoordinatesPresets();
            if (configNode.getAttribute("coordinates", "").length() > 0) {
                FileSet fileSet = new FileSet(configNode.getAttribute("coordinates", ""), viewFrame.getApp().getCodeBase().toString() + "coordinates/");
                this.getGenome(fileSet);
            } else if (((CoordinatesPresets)object).getDefaultIndex() != -1) {
                int n = ((CoordinatesPresets)object).getDefaultIndex();
                FileSet fileSet = ((CoordinatesPresets)object).getFileSet(n);
                this.getGenome(fileSet);
            } else {
                this.useOriginal();
            }
        }
        catch (LoadException loadException) {
            LogBuffer.println((String)("Error loading coordinates " + (Object)((Object)loadException)));
            loadException.printStackTrace();
            this.useOriginal();
        }
        object = KaryoscopeFactory.getColorPresets();
        if (((KaryoColorPresets)object).getDefaultIndex() != -1) {
            this.karyoDrawer.getKaryoColorSet().copyStateFrom(((KaryoColorPresets)object).getDefaultColorSet());
        }
    }

    public void getGenome(FileSet fileSet) throws LoadException {
        TVModel tVModel = new TVModel();
        tVModel.setFrame((Frame)this.viewFrame);
        tVModel.loadNew(fileSet);
        this.getGenome((DataModel)tVModel);
    }

    public void getGenome(DataModel dataModel) {
        this.coordinatesTask = new CoordinatesTask();
        this.coordinatesMonitor = new ProgressMonitor((Component)((Object)this), "Finding matching coordinates", "Note", 0, this.coordinatesTask.getLengthOfTask());
        this.coordinatesMonitor.setProgress(0);
        this.coordinatesTask.go(dataModel);
        this.coordinatesTimer.start();
    }

    public void useOriginal() {
        this.karyoDrawer.setGenome(this.startingGenome);
        this.karyoView.recalculateAverages();
        this.karyoView.redoScale();
    }

    private void setWindowActive(boolean bl) {
        this.windowActive = bl;
    }

    private void setupViews() {
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        this.addComponent(new JScrollPane(this.parameterPanel), rectangle);
        rectangle.translate(1, 0);
        this.addComponent((Component)this.statusPanel, rectangle);
        rectangle.setSize(2, 2);
        rectangle.translate(-1, 1);
        this.addComponent(this.karyoView.getComponent(), rectangle);
        this.karyoView.setParameterPanel(this.parameterPanel);
        this.karyoView.setStatusPanel(this.statusPanel);
        this.karyoView.setViewFrame(this.viewFrame);
        rectangle.translate(0, 1);
    }

    public void addComponent(Component component, Rectangle rectangle) {
        if (component != null) {
            this.addComponent(component, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void addView(ModelView modelView, Rectangle rectangle) {
        this.addComponent(modelView.getComponent(), rectangle);
        modelView.setStatusPanel(this.statusPanel);
        modelView.setViewFrame(this.viewFrame);
    }

    public boolean windowActive() {
        return this.windowActive;
    }

    public void syncConfig() {
    }

    public void showDisplayPopup() {
        DisplaySettingsPanel displaySettingsPanel = new DisplaySettingsPanel(this, KaryoscopeFactory.getColorPresets(), this.viewFrame);
        ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)this.viewFrame, "Display", (SettingsPanel)displaySettingsPanel);
        modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)this.viewFrame.getDataModel().getDocumentConfig()));
        modelessSettingsDialog.pack();
        modelessSettingsDialog.show();
    }

    public void showCoordinatesPopup() {
        this.coordinatesPanel = new CoordinatesSettingsPanel(this, KaryoscopeFactory.getCoordinatesPresets(), this.viewFrame);
        ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)this.viewFrame, "Coordinates", (SettingsPanel)this.coordinatesPanel);
        modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)this.viewFrame.getDataModel().getDocumentConfig()));
        modelessSettingsDialog.pack();
        modelessSettingsDialog.show();
    }

    public void showAveragingPopup() {
        SettingsPanel settingsPanel = this.karyoView.getAveragerSettingsPanel();
        ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)this.viewFrame, "Averaging", settingsPanel);
        modelessSettingsDialog.addWindowListener(XmlConfig.getStoreOnWindowClose((ConfigNode)this.viewFrame.getDataModel().getDocumentConfig()));
        modelessSettingsDialog.pack();
        modelessSettingsDialog.show();
    }

    public void populateSettingsMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Display...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KaryoPanel.this.showDisplayPopup();
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(68);
        treeviewMenuBarI.addMenuItem("Averaging...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KaryoPanel.this.showAveragingPopup();
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(65);
        treeviewMenuBarI.addMenuItem("Coordinates...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KaryoPanel.this.showCoordinatesPopup();
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(67);
        treeviewMenuBarI.addMenuItem("Url Links...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UrlSettingsPanel urlSettingsPanel = new UrlSettingsPanel(KaryoPanel.this.viewFrame.getUrlExtractor(), KaryoPanel.this.viewFrame.getGeneUrlPresets());
                ModelessSettingsDialog modelessSettingsDialog = new ModelessSettingsDialog((JFrame)KaryoPanel.this.viewFrame, "Url Linking", (SettingsPanel)urlSettingsPanel);
                modelessSettingsDialog.pack();
                modelessSettingsDialog.setVisible(true);
            }
        }, 0);
        treeviewMenuBarI.setMnemonic(85);
    }

    public void populateAnalysisMenu(TreeviewMenuBarI treeviewMenuBarI) {
    }

    public void populateExportMenu(TreeviewMenuBarI treeviewMenuBarI) {
        treeviewMenuBarI.addMenuItem("Export to Image...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BitmapKaryoViewExportPanel bitmapKaryoViewExportPanel = new BitmapKaryoViewExportPanel(KaryoPanel.this.karyoView);
                bitmapKaryoViewExportPanel.setSourceSet(KaryoPanel.this.viewFrame.getDataModel().getFileSet());
                CancelableSettingsDialog cancelableSettingsDialog = new CancelableSettingsDialog((JFrame)KaryoPanel.this.viewFrame, "Export to Image", (SettingsPanel)bitmapKaryoViewExportPanel);
                cancelableSettingsDialog.pack();
                int n = cancelableSettingsDialog.getWidth();
                int n2 = cancelableSettingsDialog.getHeight();
                if (n < 500) {
                    n = 500;
                }
                if (n2 < 300) {
                    n2 = 300;
                }
                cancelableSettingsDialog.setSize(n, n2);
                cancelableSettingsDialog.setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(73);
    }

    public void scrollToGene(int n) {
    }

    public void scrollToArray(int n) {
    }

    public void bindConfig(ConfigNode configNode) {
        this.configNode = configNode;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public void setGenome(Genome genome) {
        FileSet fileSet = genome.getFileSet();
        this.configNode.setAttribute("coordinates", fileSet.getRoot() + fileSet.getExt(), "");
        this.genome = genome;
    }

    public Genome getGenome() {
        return this.genome;
    }

    public void setKaryoDrawer(KaryoDrawer karyoDrawer) {
        this.karyoDrawer = karyoDrawer;
    }

    public KaryoDrawer getKaryoDrawer() {
        return this.karyoDrawer;
    }

    public void setKaryoView(KaryoView karyoView) {
        this.karyoView = karyoView;
    }

    public KaryoView getKaryoView() {
        return this.karyoView;
    }

    private ConfigNode getFirst(String string) {
        ConfigNode configNode = this.getConfigNode().fetchFirst(string);
        return configNode == null ? this.getConfigNode().create(string) : configNode;
    }

    public ImageIcon getIcon() {
        if (karyoIcon == null) {
            try {
                karyoIcon = new ImageIcon("images/karyoscope.gif", "Karyoscope Icon");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return karyoIcon;
    }

    class CoordinatesTask {
        private int current = 0;
        private String statMessage;

        CoordinatesTask() {
        }

        void go(DataModel dataModel) {
            final DataModel dataModel2 = dataModel;
            this.setCurrent(0);
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    return new ActualTask(dataModel2);
                }
            };
            swingWorker.start();
        }

        int getLengthOfTask() {
            HeaderInfo headerInfo = KaryoPanel.this.karyoView.getGeneInfo();
            return headerInfo.getNumHeaders();
        }

        int getCurrent() {
            return this.current;
        }

        void setCurrent(int n) {
            this.current = n;
        }

        public void incrCurrent() {
            ++this.current;
        }

        void stop() {
            this.current = this.getLengthOfTask();
        }

        boolean done() {
            return this.current >= this.getLengthOfTask();
        }

        String getMessage() {
            return this.statMessage;
        }

        class ActualTask {
            ActualTask(DataModel dataModel) {
                Genome genome = new Genome(dataModel);
                int n = genome.getNumLoci();
                for (int i = 0; i < n; ++i) {
                    genome.getLocus(i).setCdtIndex(-1);
                }
                CoordinatesTask.this.statMessage = "Hashing new keys ";
                HeaderInfo headerInfo = dataModel.getGeneHeaderInfo();
                int n2 = headerInfo.getNumHeaders();
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>(n2 * 4 / 3, 0.75f);
                for (int i = 0; i < n2; ++i) {
                    hashtable.put(headerInfo.getHeader(i, "YORF"), new Integer(i));
                }
                CoordinatesTask.this.statMessage = "Performing lookups";
                HeaderInfo headerInfo2 = KaryoPanel.this.karyoView.getGeneInfo();
                int n3 = headerInfo2.getNumHeaders();
                for (int i = 0; i < n3; ++i) {
                    CoordinatesTask.this.incrCurrent();
                    String string = headerInfo2.getHeader(i, "YORF");
                    if (string == null || string.equals("")) continue;
                    Integer n4 = (Integer)hashtable.get(string);
                    if (n4 != null) {
                        genome.getLocus(n4).setCdtIndex(i);
                    } else {
                        LogBuffer.println((String)("Missing locus for " + string));
                    }
                    if (CoordinatesTask.this.done()) break;
                }
                KaryoPanel.this.setGenome(genome);
                KaryoPanel.this.karyoDrawer.setGenome(genome);
                KaryoPanel.this.karyoView.recalculateAverages();
                KaryoPanel.this.karyoView.redoScale();
                CoordinatesTask.this.stop();
            }
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (KaryoPanel.this.coordinatesMonitor.isCanceled() || KaryoPanel.this.coordinatesTask.done()) {
                KaryoPanel.this.coordinatesMonitor.close();
                KaryoPanel.this.coordinatesTask.stop();
                KaryoPanel.this.coordinatesTimer.stop();
                if (KaryoPanel.this.coordinatesTask.done()) {
                    KaryoPanel.this.coordinatesMonitor.setNote("Matching complete");
                }
                if (KaryoPanel.this.coordinatesPanel != null) {
                    KaryoPanel.this.coordinatesPanel.setEnabled(true);
                }
            } else {
                KaryoPanel.this.coordinatesMonitor.setNote(KaryoPanel.this.coordinatesTask.getMessage());
                KaryoPanel.this.coordinatesMonitor.setProgress(KaryoPanel.this.coordinatesTask.getCurrent());
            }
            ((Component)((Object)KaryoPanel.this)).repaint();
        }
    }
}

