/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.Chromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;

class LinearChromosome
extends Chromosome {
    ChromosomeLocus[] leftArm;
    ChromosomeLocus[] rightArm;

    LinearChromosome(int n, int n2) {
        this.leftArm = new ChromosomeLocus[n];
        this.rightArm = new ChromosomeLocus[n2];
    }

    public void insertLocus(ChromosomeLocus chromosomeLocus) {
        ChromosomeLocus chromosomeLocus2 = null;
        ChromosomeLocus chromosomeLocus3 = null;
        if (chromosomeLocus.getArm() == 1) {
            int n = this.insertLocusIntoArray(this.leftArm, chromosomeLocus);
            if (n == -1) {
                System.out.println("could not fit locus on right arm which has length " + this.rightArm.length);
            } else {
                chromosomeLocus2 = n == 0 ? (this.rightArm.length == 0 ? null : this.rightArm[0]) : this.leftArm[n - 1];
                chromosomeLocus3 = n == this.leftArm.length - 1 ? null : this.leftArm[n + 1];
            }
        } else if (chromosomeLocus.getArm() == 2) {
            int n = this.insertLocusIntoArray(this.rightArm, chromosomeLocus);
            if (n == -1) {
                System.out.println("could not fit locus on right arm which has length " + this.rightArm.length + " which contains ");
                for (int i = 0; i < this.rightArm.length; ++i) {
                    System.out.println(this.rightArm[i].toString());
                }
            } else {
                chromosomeLocus3 = n == 0 ? (this.leftArm.length == 0 ? null : this.leftArm[0]) : this.rightArm[n - 1];
                chromosomeLocus2 = n == this.rightArm.length - 1 ? null : this.rightArm[n + 1];
            }
        }
        chromosomeLocus.setLeft(chromosomeLocus3);
        chromosomeLocus.setRight(chromosomeLocus2);
        if (chromosomeLocus3 != null) {
            chromosomeLocus3.setRight(chromosomeLocus);
        }
        if (chromosomeLocus2 != null) {
            chromosomeLocus2.setLeft(chromosomeLocus);
        }
    }

    public double getMaxPosition() {
        double d = this.leftArm.length == 0 ? 0.0 : this.leftArm[this.leftArm.length - 1].getPosition();
        double d2 = this.rightArm.length == 0 ? 0.0 : this.rightArm[this.rightArm.length - 1].getPosition();
        return d > d2 ? d : d2;
    }

    public double getMaxPosition(int n) {
        ChromosomeLocus chromosomeLocus = null;
        if (n == 1) {
            chromosomeLocus = this.getLeftEnd();
        } else if (n == 2) {
            chromosomeLocus = this.getRightEnd();
        }
        return chromosomeLocus == null ? 0.0 : chromosomeLocus.getPosition();
    }

    public ChromosomeLocus getClosestLocus(int n, double d) {
        if (n == 1) {
            return this.getLocusRecursive(d, this.leftArm, 0, this.leftArm.length - 1);
        }
        if (n == 2) {
            return this.getLocusRecursive(d, this.rightArm, 0, this.rightArm.length - 1);
        }
        return null;
    }

    public int getType() {
        return 1;
    }

    public ChromosomeLocus getLeftEnd() {
        if (this.leftArm.length != 0) {
            return this.leftArm[this.leftArm.length - 1];
        }
        if (this.rightArm.length != 0) {
            return this.rightArm[0];
        }
        return null;
    }

    public ChromosomeLocus getRightEnd() {
        if (this.rightArm.length != 0) {
            return this.rightArm[this.rightArm.length - 1];
        }
        if (this.leftArm.length != 0) {
            return this.leftArm[0];
        }
        return null;
    }

    public ChromosomeLocus getLocus(int n, int n2) {
        if (n == 1) {
            return this.leftArm[n2];
        }
        if (n == 2) {
            return this.rightArm[n2];
        }
        return null;
    }
}

