/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;
import edu.stanford.genetics.treeview.plugin.karyoview.GroupAverager;

class NeighborAverager
extends GroupAverager {
    int defaultNum = 5;

    public void setNum(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        this.getConfigNode().setAttribute("num", n, this.defaultNum);
    }

    public int getNum() {
        return this.getConfigNode().getAttribute("num", this.defaultNum);
    }

    public NeighborAverager() {
    }

    public NeighborAverager(int n) {
        this.setNum(n);
    }

    public int getType() {
        return 2;
    }

    public String getPre() {
        return this.getNum() + " Neighbors of ";
    }

    public String getArg() {
        return "" + this.getNum();
    }

    protected ChromosomeLocus[] getContributors(ChromosomeLocus chromosomeLocus) {
        int n = this.getNum();
        ChromosomeLocus[] chromosomeLocusArray = new ChromosomeLocus[n];
        ChromosomeLocus chromosomeLocus2 = chromosomeLocus.getLeft();
        ChromosomeLocus chromosomeLocus3 = chromosomeLocus.getRight();
        int n2 = (n - 1) / 2;
        int n3 = 0;
        if (!this.isNodata(chromosomeLocus)) {
            chromosomeLocusArray[n3++] = chromosomeLocus;
        }
        int n4 = 0;
        while (chromosomeLocus2 != null && n4 < n2) {
            while (chromosomeLocus2 != null && this.isNodata(chromosomeLocus2)) {
                chromosomeLocus2 = chromosomeLocus2.getLeft();
            }
            if (chromosomeLocus2 == null) continue;
            chromosomeLocusArray[n3++] = chromosomeLocus2;
            chromosomeLocus2 = chromosomeLocus2.getLeft();
            ++n4;
        }
        int n5 = 0;
        while (chromosomeLocus3 != null && n5 < n2) {
            while (chromosomeLocus3 != null && this.isNodata(chromosomeLocus3)) {
                chromosomeLocus3 = chromosomeLocus3.getRight();
            }
            if (chromosomeLocus3 == null) continue;
            chromosomeLocusArray[n3++] = chromosomeLocus3;
            chromosomeLocus3 = chromosomeLocus3.getRight();
            ++n5;
        }
        return chromosomeLocusArray;
    }
}

