/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.ColorIcon;
import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.LinkedViewFrame;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.app.LinkedViewApp;
import edu.stanford.genetics.treeview.plugin.scatterview.AxisInfo;
import edu.stanford.genetics.treeview.plugin.scatterview.AxisParameter;
import edu.stanford.genetics.treeview.plugin.scatterview.HorizontalAxisPane;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorPresets;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorSet;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterPanel;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterView;
import edu.stanford.genetics.treeview.plugin.scatterview.VerticalAxisPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DisplaySettingsPanel
extends JPanel
implements SettingsPanel {
    private ScatterColorPresets presets;
    private HorizontalAxisPane horizontalAxisPane = null;
    private VerticalAxisPane verticalAxisPane = null;
    private ScatterView scatterPane;
    private ViewFrame frame = null;
    private AxisPanel xAxisPanel;
    private AxisPanel yAxisPanel;
    private ColorConfigPanel colorPanel;
    private ColorPresetsPanel colorPresetsPanel;

    public void setPresets(ScatterColorPresets scatterColorPresets) {
        this.presets = scatterColorPresets;
    }

    public ScatterColorPresets getPresets() {
        return this.presets;
    }

    public void setScatterView(ScatterView scatterView) {
        this.scatterPane = scatterView;
    }

    public ScatterView getScatterView() {
        return this.scatterPane;
    }

    public static final void main(String[] stringArray) {
        LinkedViewApp linkedViewApp = new LinkedViewApp();
        LinkedViewFrame linkedViewFrame = new LinkedViewFrame(linkedViewApp);
        ScatterPanel scatterPanel = new ScatterPanel(linkedViewFrame, (ConfigNode)new DummyConfigNode("Display Settings Panel"));
        ScatterColorPresets scatterColorPresets = new ScatterColorPresets();
        DisplaySettingsPanel displaySettingsPanel = new DisplaySettingsPanel(scatterPanel.getScatterPane(), scatterColorPresets, (ViewFrame)linkedViewFrame);
        displaySettingsPanel.revalidate();
        JFrame jFrame = new JFrame("Test Display Settings Panel");
        jFrame.getContentPane().add(displaySettingsPanel);
        jFrame.pack();
        jFrame.show();
    }

    public DisplaySettingsPanel(ScatterView scatterView, ScatterColorPresets scatterColorPresets, ViewFrame viewFrame) {
        this(scatterView, scatterColorPresets, viewFrame, null, null);
    }

    public DisplaySettingsPanel(ScatterView scatterView, ScatterColorPresets scatterColorPresets, ViewFrame viewFrame, HorizontalAxisPane horizontalAxisPane, VerticalAxisPane verticalAxisPane) {
        this(scatterView, scatterColorPresets, scatterView.getXAxisInfo(), scatterView.getYAxisInfo(), viewFrame, horizontalAxisPane, verticalAxisPane);
    }

    public DisplaySettingsPanel(ScatterView scatterView, ScatterColorPresets scatterColorPresets, AxisInfo axisInfo, AxisInfo axisInfo2, ViewFrame viewFrame, HorizontalAxisPane horizontalAxisPane, VerticalAxisPane verticalAxisPane) {
        this.horizontalAxisPane = horizontalAxisPane;
        this.verticalAxisPane = verticalAxisPane;
        this.setScatterView(scatterView);
        this.setPresets(scatterColorPresets);
        this.setFrame(viewFrame);
        this.addWidgets();
    }

    public void setFrame(ViewFrame viewFrame) {
        this.frame = viewFrame;
    }

    public ViewFrame getFrame() {
        return this.frame;
    }

    private void addWidgets() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.xAxisPanel = new AxisPanel(this.scatterPane.getXAxisInfo());
        this.add((Component)this.xAxisPanel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.yAxisPanel = new AxisPanel(this.scatterPane.getYAxisInfo());
        this.add((Component)this.yAxisPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.colorPanel = new ColorConfigPanel();
        this.add((Component)this.colorPanel, gridBagConstraints);
    }

    public void synchronizeTo() {
    }

    public void synchronizeFrom() {
    }

    private void repaintScatterView() {
        this.scatterPane.setOffscreenValid(false);
        ((Component)((Object)this.scatterPane)).repaint();
        if (this.horizontalAxisPane != null) {
            this.horizontalAxisPane.repaint();
        }
        if (this.verticalAxisPane != null) {
            this.verticalAxisPane.repaint();
        }
    }

    private static String reformatInt(int n) {
        Integer n2 = new Integer(n);
        return n2.toString();
    }

    private static String reformatDouble(double d) {
        int n = 1;
        if (Math.abs(d) < 1.0E-7) {
            return "0.0000";
        }
        while (Math.abs(d * (double)n) < 1000.0) {
            n *= 10;
        }
        int n2 = (int)(d * (double)n);
        Double d2 = new Double((double)n2 / (double)n);
        return d2.toString();
    }

    public class ColorPanel
    extends JPanel {
        ColorIcon colorIcon;
        int type;

        public ColorPanel(int n) {
            this.type = n;
            this.redoComps();
        }

        public void redoColor() {
            this.colorIcon.setColor(this.getColor());
        }

        public void redoComps() {
            this.removeAll();
            this.colorIcon = new ColorIcon(10, 10, this.getColor());
            JButton jButton = new JButton(this.getLabel(), (Icon)this.colorIcon);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(ColorPanel.this, "Pick Color for " + ColorPanel.this.getLabel(), ColorPanel.this.getColor());
                    if (color != null) {
                        ColorPanel.this.setColor(color);
                        DisplaySettingsPanel.this.repaintScatterView();
                    }
                }
            });
            this.add(jButton);
        }

        private void setColor(Color color) {
            ScatterColorSet scatterColorSet = DisplaySettingsPanel.this.scatterPane.getColorSet();
            scatterColorSet.setColor(this.type, color);
            this.colorIcon.setColor(this.getColor());
            this.repaint();
        }

        private String getLabel() {
            ScatterColorSet scatterColorSet = DisplaySettingsPanel.this.scatterPane.getColorSet();
            return scatterColorSet.getType(this.type);
        }

        private Color getColor() {
            ScatterColorSet scatterColorSet = DisplaySettingsPanel.this.scatterPane.getColorSet();
            return scatterColorSet.getColor(this.type);
        }
    }

    class ColorPresetsPanel
    extends JPanel {
        ColorPresetsPanel() {
            this.redoLayout();
        }

        public void redoLayout() {
            this.removeAll();
            int n = DisplaySettingsPanel.this.presets.getNumPresets();
            JButton[] jButtonArray = new JButton[n];
            int n2 = 0;
            while (n2 < n) {
                JButton jButton = new JButton(DisplaySettingsPanel.this.presets.getPresetNames()[n2]);
                final int n3 = n2++;
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DisplaySettingsPanel.this.colorPanel.copyStateFrom(DisplaySettingsPanel.this.presets.getColorSet(n3));
                    }
                });
                this.add(jButton);
                jButtonArray[n3] = jButton;
            }
        }
    }

    class ColorConfigPanel
    extends JPanel {
        private final ColorPanel[] colorPanels = new ColorPanel[6];

        ColorConfigPanel() {
            try {
                this.setBorder(BorderFactory.createEtchedBorder(1));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            for (int i = 0; i < 4; ++i) {
                this.colorPanels[i] = new ColorPanel(i);
            }
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.add(this.colorPanels[0]);
            jPanel.add(this.colorPanels[1]);
            jPanel.add(this.colorPanels[2]);
            jPanel.add(this.colorPanels[3]);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("Load...");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showOpenDialog(DisplaySettingsPanel.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        ScatterColorSet scatterColorSet = DisplaySettingsPanel.this.scatterPane.getColorSet();
                        scatterColorSet.load(file.getPath());
                        for (int i = 0; i < 6; ++i) {
                            ColorConfigPanel.this.colorPanels[i].redoColor();
                        }
                        ColorConfigPanel.this.repaint();
                        DisplaySettingsPanel.this.repaintScatterView();
                    }
                }
            });
            jPanel2.add(jButton);
            JButton jButton2 = new JButton("Save...");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    int n = jFileChooser.showSaveDialog(DisplaySettingsPanel.this);
                    if (n == 0) {
                        File file = jFileChooser.getSelectedFile();
                        ScatterColorSet scatterColorSet = DisplaySettingsPanel.this.scatterPane.getColorSet();
                        scatterColorSet.save(file.getPath());
                    }
                }
            });
            jPanel2.add(jButton2);
            JButton jButton3 = new JButton("Make Preset");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScatterColorSet scatterColorSet = new ScatterColorSet();
                    ScatterColorSet scatterColorSet2 = DisplaySettingsPanel.this.scatterPane.getColorSet();
                    scatterColorSet.copyStateFrom(scatterColorSet2);
                    scatterColorSet.setName("UserDefined");
                    DisplaySettingsPanel.this.presets.addColorSet(scatterColorSet);
                    DisplaySettingsPanel.this.colorPresetsPanel.redoLayout();
                    DisplaySettingsPanel.this.colorPresetsPanel.invalidate();
                    DisplaySettingsPanel.this.colorPresetsPanel.revalidate();
                    DisplaySettingsPanel.this.colorPresetsPanel.repaint();
                }
            });
            jPanel2.add(jButton3);
            this.add(jPanel2);
            DisplaySettingsPanel.this.colorPresetsPanel = new ColorPresetsPanel();
            this.add(new JScrollPane(DisplaySettingsPanel.this.colorPresetsPanel));
            this.revalidate();
        }

        public void copyStateFrom(ScatterColorSet scatterColorSet) {
            ScatterColorSet scatterColorSet2 = DisplaySettingsPanel.this.scatterPane.getColorSet();
            scatterColorSet2.copyStateFrom(scatterColorSet);
            for (int i = 0; i < 4; ++i) {
                this.colorPanels[i].redoColor();
            }
            this.repaint();
            DisplaySettingsPanel.this.repaintScatterView();
        }

        public void getValues() {
        }

        public void setValues() {
        }
    }

    class AxisPanel
    extends JPanel {
        AxisInfo axisInfo;
        ParameterPanel minPanel;
        ParameterPanel maxPanel;
        ParameterPanel minorPanel;
        ParameterPanel majorPanel;

        AxisPanel(AxisInfo axisInfo) {
            this.axisInfo = axisInfo;
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel(axisInfo.getType() + " Axis"));
            this.minPanel = new ParameterPanel(axisInfo.getAxisParameter(0));
            this.maxPanel = new ParameterPanel(axisInfo.getAxisParameter(1));
            this.minorPanel = new ParameterPanel(axisInfo.getAxisParameter(2));
            this.majorPanel = new ParameterPanel(axisInfo.getAxisParameter(3));
            this.add(this.minPanel);
            this.add(this.maxPanel);
            this.add(this.minorPanel);
            this.add(this.majorPanel);
        }

        public void getValues() {
            this.minPanel.getValues();
            this.maxPanel.getValues();
            this.majorPanel.getValues();
            this.minorPanel.getValues();
            this.revalidate();
        }

        public void setValues() {
            this.minPanel.setValues();
            this.maxPanel.setValues();
            this.majorPanel.setValues();
            this.minorPanel.setValues();
        }

        class ParameterPanel
        extends JPanel {
            private AxisParameter axisParameter;
            private JTextField valueField;
            private JCheckBox enabledBox;

            ParameterPanel(AxisParameter axisParameter) {
                this.axisParameter = axisParameter;
                this.valueField = new JTextField("" + axisParameter.getValue());
                this.enabledBox = new JCheckBox(axisParameter.getName());
                this.enabledBox.setSelected(axisParameter.getEnabled());
                this.enabledBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ParameterPanel.this.setEnabledValue();
                    }
                });
                this.valueField.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent keyEvent) {
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                    }

                    public void keyTyped(KeyEvent keyEvent) {
                        ParameterPanel.this.enabledBox.setSelected(true);
                        ParameterPanel.this.setEnabledValue();
                    }
                });
                this.valueField.getDocument().addDocumentListener(new DocumentListener(){

                    public void insertUpdate(DocumentEvent documentEvent) {
                        ParameterPanel.this.setValue();
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        ParameterPanel.this.setValue();
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        ParameterPanel.this.setValue();
                    }
                });
                this.getValues();
                this.add(this.enabledBox);
                this.add(this.valueField);
            }

            public void getValues() {
                this.enabledBox.setSelected(this.axisParameter.getEnabled());
                this.valueField.setText("" + this.axisParameter.getValue());
            }

            public void setEnabledValue() {
                boolean bl = this.axisParameter.getEnabled();
                if (bl == this.enabledBox.isSelected()) {
                    return;
                }
                this.axisParameter.setEnabled(this.enabledBox.isSelected());
                if (this.enabledBox.isSelected()) {
                    this.setValue();
                } else {
                    DisplaySettingsPanel.this.repaintScatterView();
                }
            }

            public void setValue() {
                if (!this.enabledBox.isSelected()) {
                    return;
                }
                try {
                    Double d = new Double(this.valueField.getText());
                    double d2 = this.axisParameter.getValue();
                    if (d2 == d) {
                        return;
                    }
                    this.axisParameter.setValue(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                DisplaySettingsPanel.this.repaintScatterView();
            }

            public void setValues() {
                this.setEnabledValue();
                this.setValue();
            }
        }
    }
}

