/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.NoValueException;
import edu.stanford.genetics.treeview.plugin.scatterview.SPDataSource;
import java.awt.Color;

class DummySource
implements SPDataSource {
    public Color foreColor = Color.green;
    public Color selColor = Color.red;
    int xmod;
    int ymod;
    boolean[] selected;

    DummySource(int n, int n2) {
        this.xmod = n;
        this.ymod = n2;
        this.selected = new boolean[10000];
    }

    public int getNumPoints() {
        return this.selected.length;
    }

    public double getX(int n) throws NoValueException {
        return n % this.xmod;
    }

    public double getY(int n) throws NoValueException {
        return n % this.ymod;
    }

    public String getLabel(int n) {
        return "Dummy " + n;
    }

    public Color getColor(int n) {
        if (this.selected[n]) {
            return this.selColor;
        }
        return this.foreColor;
    }

    public String getTitle() {
        return "Modulo Fun!";
    }

    public String getXLabel() {
        return "Index mod " + this.xmod;
    }

    public String getYLabel() {
        return "Index mod " + this.ymod;
    }

    public boolean isSelected(int n) {
        return this.selected[n];
    }

    public void select(int n) {
        try {
            System.out.println("Selected point " + n + " at (" + this.getX(n) + ", " + this.getY(n) + ")");
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        this.selected[n] = true;
    }

    public void select(double d, double d2, double d3, double d4) {
        int n = this.getNumPoints();
        for (int i = 0; i < n; ++i) {
            try {
                double d5 = this.getX(i);
                double d6 = this.getY(i);
                if (!(d5 > d) || !(d5 < d3) || !(d6 > d2) || !(d6 < d4)) continue;
                this.select(i);
                continue;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
    }

    public void deselectAll() {
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i] = false;
        }
    }
}

