/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LinkedViewFrame;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.PluginFactory;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SettingsPanelHolder;
import edu.stanford.genetics.treeview.TabbedSettingsPanel;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.core.PluginManager;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorPresetEditor;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorPresets;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScatterplotFactory
extends PluginFactory {
    private static ScatterColorPresets colorPresets = new ScatterColorPresets();
    private ScatterColorPresetEditor cpresetEditor = new ScatterColorPresetEditor(colorPresets);
    private JFrame cpresetFrame = null;
    private TabbedSettingsPanel tabbedPanel;

    public String getPluginName() {
        return "Scatterplot";
    }

    public MainPanel restorePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        ScatterPanel scatterPanel = new ScatterPanel((LinkedViewFrame)viewFrame, configNode);
        scatterPanel.setSelection(viewFrame.getGeneSelection());
        scatterPanel.setName(this.getPluginName());
        return scatterPanel;
    }

    public ScatterplotFactory() {
        this.cpresetEditor.setTitle("Scatterplot Color Presets");
    }

    public void setGlobalNode(ConfigNode configNode) {
        super.setGlobalNode(configNode);
        colorPresets.bindConfig(configNode.fetchOrCreate("ColorPresets"));
        if (colorPresets.getNumPresets() == 0) {
            colorPresets.addDefaultPresets();
        }
        this.cpresetEditor.synchronizeFrom();
    }

    public void addPluginConfig(TreeviewMenuBarI treeviewMenuBarI, final ViewFrame viewFrame) {
        super.addPluginConfig(treeviewMenuBarI, viewFrame);
        treeviewMenuBarI.addMenuItem("Scatterplot Color...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ScatterplotFactory.this.cpresetFrame == null) {
                    ScatterplotFactory.this.setupPresetsFrame(viewFrame.getApp().getGlobalConfig().getRoot());
                }
                ScatterplotFactory.this.tabbedPanel.setSelectedComponent(ScatterplotFactory.this.cpresetEditor);
                ((Component)ScatterplotFactory.this.cpresetFrame).setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(83);
    }

    private void setupPresetsFrame(ConfigNode configNode) {
        this.cpresetFrame = new JFrame("Scatterplot Color");
        SettingsPanelHolder settingsPanelHolder = new SettingsPanelHolder((Window)this.cpresetFrame, configNode);
        settingsPanelHolder.addSettingsPanel((SettingsPanel)this.cpresetEditor);
        this.cpresetFrame.getContentPane().add((Component)settingsPanelHolder);
        this.cpresetFrame.pack();
    }

    public static ScatterColorPresets getColorPresets() {
        return colorPresets;
    }

    public boolean configurePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        GraphDialog graphDialog = new GraphDialog(configNode, viewFrame);
        try {
            graphDialog.setLocationRelativeTo((Component)viewFrame);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        graphDialog.pack();
        ((Component)graphDialog).setVisible(true);
        return true;
    }

    static {
        PluginManager.registerPlugin((PluginFactory)new ScatterplotFactory());
    }

    private class GraphDialog
    extends JDialog {
        StatPanel xPanel;
        StatPanel yPanel;
        ViewFrame frame;
        ConfigNode node;
        int npre;
        int nexpr;
        MenuItem ratioItem = new MenuItem("Make Scatterplot of Genes...");

        GraphDialog(ConfigNode configNode, ViewFrame viewFrame) {
            super((Frame)viewFrame, "Create Graph...", true);
            this.frame = viewFrame;
            this.node = configNode;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.yPanel = new StatPanel("Y Axis:");
            this.xPanel = new StatPanel("X Axis:");
            jPanel.add(new JLabel("Create Graph:"));
            jPanel.add(this.yPanel);
            jPanel.add(this.xPanel);
            jPanel.add(new ButtonPanel());
            this.setContentPane(jPanel);
        }

        class ButtonPanel
        extends JPanel {
            private JButton closeButton;
            private JButton goButton = new JButton("Go!");

            ButtonPanel() {
                this.goButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = ((ButtonPanel)ButtonPanel.this).GraphDialog.this.xPanel.getType();
                        int n2 = ((ButtonPanel)ButtonPanel.this).GraphDialog.this.xPanel.getIndex();
                        int n3 = ((ButtonPanel)ButtonPanel.this).GraphDialog.this.yPanel.getType();
                        int n4 = ((ButtonPanel)ButtonPanel.this).GraphDialog.this.yPanel.getIndex();
                        ((ButtonPanel)ButtonPanel.this).GraphDialog.this.node.setAttribute("type", "Scatterplot", null);
                        ((ButtonPanel)ButtonPanel.this).GraphDialog.this.node.setAttribute("xtype", n, 0);
                        ((ButtonPanel)ButtonPanel.this).GraphDialog.this.node.setAttribute("ytype", n3, 0);
                        ((ButtonPanel)ButtonPanel.this).GraphDialog.this.node.setAttribute("xindex", n2, 0);
                        ((ButtonPanel)ButtonPanel.this).GraphDialog.this.node.setAttribute("yindex", n4, 0);
                        GraphDialog.this.dispose();
                    }
                });
                this.add(this.goButton);
                this.closeButton = new JButton("Cancel");
                this.closeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GraphDialog.this.dispose();
                    }
                });
                this.add(this.closeButton);
            }
        }

        class StatPanel
        extends JPanel {
            JComboBox statPulldown;

            StatPanel(String string) {
                super(false);
                int n;
                DataModel dataModel = GraphDialog.this.frame.getDataModel();
                HeaderInfo headerInfo = dataModel.getArrayHeaderInfo();
                HeaderInfo headerInfo2 = dataModel.getGeneHeaderInfo();
                int n2 = 0;
                GraphDialog.this.npre = headerInfo2.getNumNames();
                GraphDialog.this.nexpr = headerInfo.getNumHeaders();
                String[] stringArray = new String[GraphDialog.this.npre + GraphDialog.this.nexpr + 1];
                stringArray[0] = "INDEX";
                String[] stringArray2 = headerInfo2.getNames();
                for (n = 0; n < GraphDialog.this.npre; ++n) {
                    stringArray[n + 1] = stringArray2[n];
                }
                for (n = 0; n < GraphDialog.this.nexpr; ++n) {
                    stringArray[n + 1 + GraphDialog.this.npre] = headerInfo.getHeader(n)[n2];
                }
                this.add(new JLabel(string));
                this.statPulldown = new JComboBox<String>(stringArray);
                this.add(this.statPulldown);
            }

            int getType() {
                if (this.statPulldown.getSelectedIndex() == 0) {
                    return 0;
                }
                if (this.statPulldown.getSelectedIndex() <= GraphDialog.this.npre) {
                    return 2;
                }
                return 1;
            }

            int getIndex() {
                if (this.getType() == 2) {
                    return this.statPulldown.getSelectedIndex() - 1;
                }
                if (this.getType() == 1) {
                    return this.statPulldown.getSelectedIndex() - 1 - GraphDialog.this.npre;
                }
                return -1;
            }
        }
    }
}

