/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ATRZoomView
extends ModelView
implements MouseListener,
KeyListener {
    protected HeaderSummary headerSummary = new HeaderSummary();
    private static final String[] hints = new String[]{"Click to select node", " - use arrow keys to navigate tree"};
    private TreeSelectionI arraySelection;
    private LinearTransformation xScaleEq;
    private LinearTransformation yScaleEq;
    private MapContainer zoomMap;
    private JScrollBar scrollbar;
    private InvertedTreeDrawer drawer = null;
    private TreeDrawerNode selectedNode = null;
    private Rectangle destRect = null;

    public ATRZoomView() {
        this.panel = new JPanel();
        this.scrollbar = new JScrollBar(1, 0, 1, 0, 1);
        this.destRect = new Rectangle();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)((Object)this), "Center");
        this.panel.add((Component)this.scrollbar, "East");
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addKeyListener(this);
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public String[] getHints() {
        return hints;
    }

    public void setSelectedNode(TreeDrawerNode treeDrawerNode) {
        if (this.selectedNode == treeDrawerNode) {
            return;
        }
        this.selectedNode = treeDrawerNode;
        this.offscreenValid = false;
        if (this.status != null && this.hasMouse) {
            this.status.setMessages(this.getStatus());
        }
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void synchMap() {
        if (this.selectedNode != null && this.arraySelection != null) {
            int n = (int)this.selectedNode.getLeftLeaf().getIndex();
            int n2 = (int)this.selectedNode.getRightLeaf().getIndex();
            if (this.viewFrame.getDataModel().getDataMatrix().getNumCol() > this.viewFrame.getDataModel().getDataMatrix().getNumUnappendedCol()) {
                n2 = Math.max(this.viewFrame.getDataModel().getDataMatrix().getNumCol(), n2);
            }
            this.arraySelection.deselectAllIndexes();
            this.arraySelection.setSelectedNode(this.selectedNode.getId());
            this.arraySelection.selectIndexRange(n, n2);
            this.arraySelection.notifyObservers();
        }
    }

    public void setArraySelection(TreeSelectionI treeSelectionI) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver((Observer)((Object)this));
        }
        this.arraySelection = treeSelectionI;
        this.arraySelection.addObserver((Observer)((Object)this));
    }

    public void setInvertedTreeDrawer(InvertedTreeDrawer invertedTreeDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver((Observer)((Object)this));
        }
        this.drawer = invertedTreeDrawer;
        this.drawer.addObserver((Observer)((Object)this));
    }

    public void setZoomMap(MapContainer mapContainer) {
        if (this.zoomMap != null) {
            this.zoomMap.deleteObserver((Observer)((Object)this));
        }
        this.zoomMap = mapContainer;
        this.zoomMap.addObserver((Observer)((Object)this));
    }

    public void update(Observable observable, Object object) {
        if (observable == this.drawer) {
            this.offscreenValid = false;
            ((Component)((Object)this)).repaint();
        } else if (observable == this.zoomMap) {
            this.offscreenValid = false;
            ((Component)((Object)this)).repaint();
        } else if (observable == this.arraySelection) {
            this.setSelectedNode(this.drawer.getNodeById(this.arraySelection.getSelectedNode()));
        } else {
            System.out.println(this.viewName() + "Got an update from unknown " + observable);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ((Component)((Object)this)).repaint();
    }

    public String viewName() {
        return "ATRZoomView";
    }

    public String[] getStatus() {
        String[] stringArray;
        if (this.selectedNode != null) {
            int[] nArray = this.getHeaderSummary().getIncluded();
            stringArray = new String[nArray.length * 2];
            HeaderInfo headerInfo = this.getViewFrame().getDataModel().getAtrHeaderInfo();
            String[] stringArray2 = headerInfo.getNames();
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[2 * i] = stringArray2[nArray[i]] + ":";
                stringArray[2 * i + 1] = " " + headerInfo.getHeader(headerInfo.getHeaderIndex(this.selectedNode.getId()))[nArray[i]];
            }
        } else {
            stringArray = new String[]{"Select Node to ", "view annotation."};
        }
        return stringArray;
    }

    public void updateBuffer(Graphics graphics) {
        if (this.offscreenChanged) {
            this.offscreenValid = false;
        }
        if (!this.offscreenValid) {
            if (this.drawer != null && this.selectedNode != null) {
                this.zoomMap.setAvailablePixels(this.offscreenSize.width);
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
                graphics.setColor(Color.black);
                if (this.selectedNode.isLeaf()) {
                    return;
                }
                this.destRect.setBounds(0, 0, this.zoomMap.getUsedPixels(), this.offscreenSize.height);
                graphics.setClip(this.destRect.x, this.destRect.y, this.destRect.width, this.destRect.height);
                this.xScaleEq = new LinearTransformation((double)this.zoomMap.getIndex(this.destRect.x), (double)this.destRect.x, (double)this.zoomMap.getIndex(this.destRect.x + this.destRect.width), (double)(this.destRect.x + this.destRect.width));
                this.yScaleEq = new LinearTransformation(this.selectedNode.getMinCorr(), (double)this.destRect.y, this.drawer.getCorrMax(), (double)(this.destRect.y + this.destRect.height));
                this.drawer.paint(graphics, this.xScaleEq, this.yScaleEq, this.destRect, null);
            } else {
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.offscreenSize.width, this.offscreenSize.height);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this == null) {
            return;
        }
        if (!((Component)((Object)this)).isEnabled()) {
            return;
        }
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        if (this.drawer != null) {
            this.setSelectedNode(this.drawer.getClosest(this.xScaleEq.inverseTransform((double)mouseEvent.getX()), this.yScaleEq.inverseTransform((double)mouseEvent.getY()), this.yScaleEq.getSlope() / this.xScaleEq.getSlope()));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.selectedNode == null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        TreeDrawerNode treeDrawerNode = null;
        switch (n) {
            case 38: {
                treeDrawerNode = this.selectedNode.getParent();
                break;
            }
            case 37: {
                if (this.selectedNode.isLeaf()) break;
                treeDrawerNode = this.selectedNode.getRight();
                break;
            }
            case 39: {
                if (this.selectedNode.isLeaf()) break;
                treeDrawerNode = this.selectedNode.getLeft();
                break;
            }
            case 40: {
                if (this.selectedNode.isLeaf()) break;
                TreeDrawerNode treeDrawerNode2 = this.selectedNode.getRight();
                TreeDrawerNode treeDrawerNode3 = this.selectedNode.getLeft();
                treeDrawerNode = treeDrawerNode2.getRange() > treeDrawerNode3.getRange() ? treeDrawerNode2 : treeDrawerNode3;
            }
        }
        if (treeDrawerNode != null) {
            this.setSelectedNode(treeDrawerNode);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

