/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.PluginFactory;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.core.PluginManager;
import edu.stanford.genetics.treeview.plugin.dendroview.CharDendroView;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class AlignmentFactory
extends PluginFactory {
    public String getPluginName() {
        return "Alignment";
    }

    public MainPanel restorePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        if (configNode.getAttribute("headerName", null) == null) {
            return null;
        }
        CharDendroView charDendroView = new CharDendroView(viewFrame, configNode);
        charDendroView.setName(this.getPluginName());
        return charDendroView;
    }

    public boolean configurePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        if (viewFrame.getDataModel().getGeneHeaderInfo().getIndex("ALN") >= 0) {
            configNode.setAttribute("headerName", "ALN", null);
            return true;
        }
        JOptionPane.showMessageDialog((Component)viewFrame, new JTextArea("Cannot find aligned sequence.\nPlease put aligned sequence in column titled \"ALN\"."));
        return false;
    }

    static {
        PluginManager.registerPlugin((PluginFactory)new AlignmentFactory());
    }
}

