/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.DataModel;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.RotateImageFilter;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.UrlExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelectable;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeColorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class ArrayNameView
extends ModelView
implements MouseListener,
FontSelectable,
ConfigNodePersistent {
    private final String d_face = "Courier";
    private final int d_style = 0;
    private final int d_size = 12;
    protected HeaderInfo headerInfo = null;
    protected DataModel dataModel = null;
    private ConfigNode root = null;
    private String face;
    private int style;
    private int size;
    private UrlExtractor urlExtractor = null;
    private MapContainer map;
    private int maxlength = 0;
    private boolean backBufferValid = false;
    private Image backBuffer;
    private JScrollPane scrollPane;
    private int oldHeight = 0;
    private HeaderSummary headerSummary;
    private TreeSelectionI arraySelection;

    public HeaderInfo getHeaderInfo() {
        return this.headerInfo;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setHeaderInfo(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
    }

    public void setDataModel(DataModel dataModel) {
        if (dataModel != null) {
            ((Observable)dataModel).deleteObserver((Observer)((Object)this));
        }
        this.dataModel = dataModel;
        ((Observable)dataModel).addObserver((Observer)((Object)this));
    }

    public String viewName() {
        return "ArrayNameView";
    }

    public String[] getHints() {
        String[] stringArray = new String[]{"Click and drag to scroll"};
        return stringArray;
    }

    public ArrayNameView(HeaderInfo headerInfo) {
        this.headerInfo = headerInfo;
        this.headerSummary = new HeaderSummary();
        this.headerSummary.setIncluded(new int[]{0});
        this.scrollPane = new JScrollPane((Component)((Object)this));
        this.scrollPane.setBorder(null);
        this.panel = this.scrollPane;
        ((Component)((Object)this)).addMouseListener(this);
    }

    public void updateBackBuffer() {
        Object object;
        int n;
        Color color;
        Graphics graphics = this.backBuffer.getGraphics();
        int n2 = this.map.getIndex(0);
        int n3 = this.map.getIndex(this.map.getUsedPixels()) - 1;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.maxlength, this.offscreenSize.width);
        graphics.setColor(Color.black);
        int n4 = this.headerInfo.getIndex("GID");
        if (n4 == -1) {
            n4 = 0;
        }
        int n5 = this.headerInfo.getIndex("FGCOLOR");
        graphics.setFont(new Font(this.face, this.style, this.size));
        FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(graphics.getFont());
        int n6 = fontMetrics.getAscent();
        int n7 = this.headerInfo.getIndex("BGCOLOR");
        if (n7 > 0) {
            color = graphics.getColor();
            for (n = n2; n < n3; ++n) {
                object = this.headerInfo.getHeader(n);
                try {
                    graphics.setColor(TreeColorer.getColor(object[n7]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics.fillRect(0, this.map.getMiddlePixel(n) - n6 / 2, this.maxlength, n6);
            }
            graphics.setColor(color);
        }
        color = graphics.getColor();
        for (n = n2; n <= n3; ++n) {
            try {
                object = this.headerSummary.getSummary(this.headerInfo, n);
                String[] stringArray = this.headerInfo.getHeader(n);
                if (object == null) continue;
                if (this.arraySelection == null || this.arraySelection.isIndexSelected(n)) {
                    if (n5 > 0) {
                        graphics.setColor(TreeColorer.getColor(stringArray[n5]));
                    }
                    graphics.drawString((String)object, 0, this.map.getMiddlePixel(n) + n6 / 2);
                    if (n5 <= 0) continue;
                    graphics.setColor(color);
                    continue;
                }
                graphics.setColor(Color.gray);
                graphics.drawString((String)object, 0, this.map.getMiddlePixel(n) + n6 / 2);
                graphics.setColor(color);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.backBuffer = RotateImageFilter.rotate((Component)((Object)this), (Image)this.backBuffer);
    }

    public void updateBuffer(Graphics graphics) {
        this.updateBuffer(graphics, this.offscreenSize);
    }

    public void updateBuffer(Image image) {
        this.updateBuffer(image.getGraphics(), new Dimension(image.getWidth(null), image.getHeight(null)));
    }

    public void updateBuffer(Graphics graphics, Dimension dimension) {
        block15: {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            try {
                Object object;
                int n;
                Color color;
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.rotate(-1.570795);
                graphics2D.translate(-dimension.height, 0);
                int n2 = this.map.getIndex(0);
                int n3 = this.map.getIndex(this.map.getUsedPixels()) - 1;
                int n4 = this.headerInfo.getIndex("GID");
                if (n4 == -1) {
                    n4 = 0;
                }
                int n5 = this.headerInfo.getIndex("FGCOLOR");
                graphics.setFont(new Font(this.face, this.style, this.size));
                FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(graphics.getFont());
                int n6 = fontMetrics.getAscent();
                int n7 = this.headerInfo.getIndex("BGCOLOR");
                if (n7 > 0) {
                    color = graphics.getColor();
                    for (n = n2; n <= n3; ++n) {
                        object = this.headerInfo.getHeader(n);
                        try {
                            graphics.setColor(TreeColorer.getColor(object[n7]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        graphics.fillRect(0, this.map.getMiddlePixel(n) - n6 / 2, dimension.height, n6);
                    }
                    graphics.setColor(color);
                }
                color = graphics.getColor();
                for (n = n2; n <= n3; ++n) {
                    try {
                        object = this.headerSummary.getSummary(this.headerInfo, n);
                        String[] stringArray = this.headerInfo.getHeader(n);
                        if (object == null) continue;
                        if (this.arraySelection == null || this.arraySelection.isIndexSelected(n)) {
                            if (n5 > 0) {
                                graphics.setColor(TreeColorer.getColor(stringArray[n5]));
                            }
                            graphics.drawString((String)object, 0, this.map.getMiddlePixel(n) + n6 / 2);
                            if (n5 <= 0) continue;
                            graphics.setColor(color);
                            continue;
                        }
                        graphics.setColor(Color.gray);
                        graphics.drawString((String)object, 0, this.map.getMiddlePixel(n) + n6 / 2);
                        graphics.setColor(color);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                graphics2D.translate(dimension.height, 0);
                graphics2D.rotate(1.570795);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!this.backBufferValid) {
                    int n = this.map.getIndex(0);
                    int n8 = this.map.getIndex(this.map.getUsedPixels());
                    if (n >= 0 && n8 > n && dimension.width > 0) {
                        this.backBuffer = ((Component)((Object)this)).createImage(this.maxlength, dimension.width);
                        this.updateBackBuffer();
                    }
                    this.backBufferValid = true;
                }
                if (dimension.height < this.maxlength) {
                    graphics.drawImage(this.backBuffer, 0, 0, null);
                }
                if (graphics == null || this.backBuffer == null) break block15;
                graphics.drawImage(this.backBuffer, 0, dimension.height - this.maxlength, null);
            }
        }
    }

    public void setUrlExtractor(UrlExtractor urlExtractor) {
        this.urlExtractor = urlExtractor;
    }

    public void setMapping(MapContainer mapContainer) {
        if (this.map != null) {
            this.map.deleteObserver((Observer)((Object)this));
        }
        this.map = mapContainer;
        this.map.addObserver((Observer)((Object)this));
    }

    private void selectionChanged() {
        this.offscreenValid = false;
        this.backBufferValid = false;
        int n = this.map.getMinIndex();
        int n2 = this.map.getMaxIndex();
        int n3 = this.headerInfo.getIndex("GID");
        if (n3 == -1) {
            n3 = 0;
        }
        FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(new Font(this.face, this.style, this.size));
        this.maxlength = 1;
        for (int i = n; i < n2; ++i) {
            int n4;
            String[] stringArray = this.headerInfo.getHeader(i);
            String string = this.headerSummary.getSummary(this.headerInfo, i);
            if (string == null || this.maxlength >= (n4 = fontMetrics.stringWidth(string))) continue;
            this.maxlength = n4;
        }
        Rectangle rectangle = ((JComponent)((Object)this)).getVisibleRect();
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(this.map.getUsedPixels(), this.maxlength));
        ((JComponent)((Object)this)).revalidate();
        ((Component)((Object)this)).repaint();
        if (this.maxlength > this.oldHeight) {
            rectangle.y += this.maxlength - this.oldHeight;
            ((JComponent)((Object)this)).scrollRectToVisible(rectangle);
        }
        this.oldHeight = this.maxlength;
    }

    public void update(Observable observable, Object object) {
        if (observable == this.map || observable == this.dataModel) {
            this.selectionChanged();
        } else if (observable == this.arraySelection) {
            this.selectionChanged();
        } else {
            System.out.println("ArrayNameView got funny update!");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.urlExtractor == null) {
            return;
        }
        if (!this.urlExtractor.isEnabled()) {
            return;
        }
        int n = this.map.getIndex(mouseEvent.getX());
        if (this.map.contains(n)) {
            this.viewFrame.displayURL(this.urlExtractor.getUrl(n));
        }
    }

    public String getFace() {
        return this.face;
    }

    public int getPoints() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public void setFace(String string) {
        if (this.face == null || !this.face.equals(string)) {
            this.face = string;
            if (this.root != null) {
                this.root.setAttribute("face", this.face, "Courier");
            }
            ((JComponent)((Object)this)).setFont(new Font(this.face, this.style, this.size));
            this.backBufferValid = false;
            ((Component)((Object)this)).repaint();
        }
    }

    public void setPoints(int n) {
        if (this.size != n) {
            this.size = n;
            if (this.root != null) {
                this.root.setAttribute("size", this.size, 12);
            }
            ((JComponent)((Object)this)).setFont(new Font(this.face, this.style, this.size));
            this.backBufferValid = false;
            ((Component)((Object)this)).repaint();
        }
    }

    public void setStyle(int n) {
        if (this.style != n) {
            this.style = n;
            this.backBufferValid = false;
            if (this.root != null) {
                this.root.setAttribute("style", this.style, 0);
            }
            ((JComponent)((Object)this)).setFont(new Font(this.face, this.style, this.size));
            ((Component)((Object)this)).repaint();
        }
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        if (configNode.fetchFirst("ArraySummary") == null) {
            this.getHeaderSummary().bindConfig(configNode.create("ArraySummary"));
            this.getHeaderSummary().setIncluded(new int[]{0});
        } else {
            this.getHeaderSummary().bindConfig(configNode.fetchFirst("ArraySummary"));
        }
        this.setFace(this.root.getAttribute("face", "Courier"));
        this.setStyle(this.root.getAttribute("style", 0));
        this.setPoints(this.root.getAttribute("size", 12));
    }

    public void setArraySelection(TreeSelectionI treeSelectionI) {
        if (this.arraySelection != null) {
            this.arraySelection.deleteObserver((Observer)((Object)this));
        }
        this.arraySelection = treeSelectionI;
        this.arraySelection.addObserver((Observer)((Object)this));
    }
}

