/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.BitmapWriter;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorBarExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BitmapColorBarExportPanel
extends ColorBarExportPanel
implements SettingsPanel {
    JComboBox formatPulldown = new JComboBox<String>(BitmapWriter.formats);

    public BitmapColorBarExportPanel(ColorExtractor colorExtractor) {
        super(colorExtractor);
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox("Append Extension?", true);
        this.formatPulldown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    BitmapColorBarExportPanel.this.appendExtension();
                }
            }
        });
        jPanel.add(new JLabel("Image Format:"));
        jPanel.add(this.formatPulldown);
        jPanel.add(jCheckBox);
        this.add(jPanel);
    }

    private void appendExtension() {
        int n;
        String string = this.getFilePath();
        int n2 = string.lastIndexOf(46);
        if (n2 > (n = string.lastIndexOf(File.separatorChar))) {
            this.setFilePath(string.substring(0, n2) + "." + this.formatPulldown.getSelectedItem());
        } else {
            this.setFilePath(string + "." + this.formatPulldown.getSelectedItem());
        }
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            BufferedImage bufferedImage = this.generateImage();
            String string = (String)this.formatPulldown.getSelectedItem();
            boolean bl = BitmapWriter.writeBitmap((BufferedImage)bufferedImage, (String)string, (OutputStream)bufferedOutputStream, (JComponent)this);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, new JTextArea("Colorbar Image export had problem " + exception));
            LogBuffer.println((String)("Exception " + exception));
            exception.printStackTrace();
        }
    }

    protected boolean hasBbox() {
        return false;
    }

    protected String getInitialExtension() {
        return "_colorbar.png";
    }
}

