/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.BitmapWriter;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.ExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BitmapExportPanel
extends ExportPanel
implements SettingsPanel {
    JComboBox formatPulldown = new JComboBox<String>(BitmapWriter.formats);

    public BitmapExportPanel(HeaderInfo headerInfo, HeaderInfo headerInfo2, TreeSelectionI treeSelectionI, TreeSelectionI treeSelectionI2, InvertedTreeDrawer invertedTreeDrawer, LeftTreeDrawer leftTreeDrawer, ArrayDrawer arrayDrawer, MapContainer mapContainer, MapContainer mapContainer2) {
        this(headerInfo, headerInfo2, treeSelectionI, treeSelectionI2, invertedTreeDrawer, leftTreeDrawer, arrayDrawer, mapContainer, mapContainer2, false);
    }

    public BitmapExportPanel(HeaderInfo headerInfo, HeaderInfo headerInfo2, TreeSelectionI treeSelectionI, TreeSelectionI treeSelectionI2, InvertedTreeDrawer invertedTreeDrawer, LeftTreeDrawer leftTreeDrawer, ArrayDrawer arrayDrawer, MapContainer mapContainer, MapContainer mapContainer2, boolean bl) {
        super(headerInfo, headerInfo2, treeSelectionI, treeSelectionI2, invertedTreeDrawer, leftTreeDrawer, arrayDrawer, mapContainer, mapContainer2, bl);
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox("Append Extension?", true);
        this.formatPulldown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jCheckBox.isSelected()) {
                    BitmapExportPanel.this.appendExtension();
                }
            }
        });
        jPanel.add(new JLabel("Image Format:"));
        jPanel.add(this.formatPulldown);
        jPanel.add(jCheckBox);
        this.add(jPanel);
    }

    private void appendExtension() {
        int n;
        String string = this.getFilePath();
        int n2 = string.lastIndexOf(46);
        if (n2 > (n = string.lastIndexOf(File.separatorChar))) {
            this.setFilePath(string.substring(0, n2) + "." + this.formatPulldown.getSelectedItem());
        } else {
            this.setFilePath(string + "." + this.formatPulldown.getSelectedItem());
        }
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            int n = this.getBorderPixels();
            int n2 = this.getBorderPixels();
            Rectangle rectangle = new Rectangle(0, 0, this.estimateWidth(), this.estimateHeight());
            BufferedImage bufferedImage = new BufferedImage(rectangle.width + n, rectangle.height + n2, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, rectangle.width + 1 + n, rectangle.height + 1 + n2);
            graphics.setColor(Color.black);
            graphics.translate(n2 / 2, n / 2);
            this.drawAll(graphics, 1.0);
            String string = (String)this.formatPulldown.getSelectedItem();
            boolean bl = BitmapWriter.writeBitmap((BufferedImage)bufferedImage, (String)string, (OutputStream)bufferedOutputStream, (JComponent)this);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, new JTextArea("Dendrogram export had problem " + exception));
            LogBuffer.println((String)("Exception " + exception));
            exception.printStackTrace();
        }
    }

    protected boolean hasBbox() {
        return false;
    }

    protected String getInitialExtension() {
        return ".png";
    }

    class DendroPngWriter {
        DendroPngWriter() {
        }

        public void write(OutputStream outputStream) {
        }
    }
}

