/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.plugin.dendroview.CharColorSet;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import java.awt.Color;
import java.util.Observable;

public class CharColorExtractor
extends Observable
implements ConfigNodePersistent {
    private static CharColorSet defaultColorSet = new CharColorSet();
    private final CharColorSet colorSet = new CharColorSet();
    private ConfigNode root;

    public CharColorExtractor() {
        this.colorSet.copyStateFrom(defaultColorSet);
    }

    public void setDefaultColorSet(CharColorSet charColorSet) {
        defaultColorSet = charColorSet;
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        ConfigNode configNode2 = this.root.fetchFirst("ColorSet");
        if (configNode2 == null) {
            configNode2 = this.root.create("CharColorSet");
        }
        this.colorSet.bindConfig(configNode2);
    }

    public Color getMissing() {
        return this.colorSet.getMissing();
    }

    public Color getEmpty() {
        return this.colorSet.getEmpty();
    }

    public void setColor(char c, String string) {
        if (ColorSet.encodeColor(this.colorSet.getColor(c)).equals(string)) {
            return;
        }
        this.colorSet.setColor(c, ColorSet.decodeColor(string));
        this.setChanged();
    }

    public void setMissingColor(String string) {
        if (ColorSet.encodeColor(this.colorSet.getMissing()).equals(string)) {
            return;
        }
        this.colorSet.setMissing(ColorSet.decodeColor(string));
        this.setChanged();
    }

    public void setEmptyColor(String string) {
        if (string == null) {
            return;
        }
        if (ColorSet.encodeColor(this.colorSet.getEmpty()).equals(string)) {
            return;
        }
        this.colorSet.setEmpty(ColorSet.decodeColor(string));
        this.setChanged();
    }

    public void setColor(char c, Color color) {
        if (this.colorSet.getColor(c).equals(color)) {
            return;
        }
        this.colorSet.setColor(c, color);
        this.setChanged();
    }

    public void setMissingColor(Color color) {
        if (this.colorSet.getMissing().equals(color)) {
            return;
        }
        this.colorSet.setMissing(color);
        this.setChanged();
    }

    public void setEmptyColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.colorSet.getEmpty().equals(color)) {
            return;
        }
        this.colorSet.setEmpty(color);
        this.setChanged();
    }

    public Color getColor(char c) {
        return this.colorSet.getColor(c);
    }

    public float[] getFloatColor(char c) {
        return this.getColor(c).getComponents(null);
    }

    public void printSelf() {
        System.out.println("missingColor " + this.getMissing());
        System.out.println("emptyColor " + this.getEmpty());
    }

    public int getARGBColor(char c) {
        return this.getColor(c).getRGB();
    }

    public void setDefaults() {
        this.setMissingColor(ColorSet.encodeColor(defaultColorSet.getMissing()));
        this.setEmptyColor(ColorSet.encodeColor(defaultColorSet.getEmpty()));
        this.setChanged();
    }
}

