/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import java.awt.Color;

public class CharColorSet
implements ConfigNodePersistent {
    public static final int maxChar = 128;
    private String default_missingColor = "#FFFFFF";
    private String default_emptyColor = "#FFFFFF";
    private String default_name = null;
    private String name;
    private Color missing;
    private Color empty;
    private Color[] charColors = new Color[128];
    private ConfigNode root = null;

    public CharColorSet() {
        this.setAADefaults();
    }

    public CharColorSet(String string, String string2, String string3) {
        this();
        this.setName(string);
        this.setMissing(string2);
        this.setEmpty(string3);
    }

    private void setAADefaults() {
        char c;
        this.missing = CharColorSet.decodeColor(this.default_missingColor);
        this.empty = CharColorSet.decodeColor(this.default_emptyColor);
        for (c = '\u0000'; c < '\u0080'; c = (char)((char)(c + 1))) {
            this.charColors[c] = null;
        }
        this.charColors[68] = CharColorSet.decodeColor("#E60A0A");
        this.charColors[69] = this.charColors[68];
        this.charColors[67] = CharColorSet.decodeColor("#E6E600");
        this.charColors[77] = this.charColors[67];
        this.charColors[75] = CharColorSet.decodeColor("#145AFF");
        this.charColors[82] = this.charColors[75];
        this.charColors[83] = CharColorSet.decodeColor("#FA9600");
        this.charColors[84] = this.charColors[83];
        this.charColors[70] = CharColorSet.decodeColor("#3232AA");
        this.charColors[89] = this.charColors[70];
        this.charColors[78] = CharColorSet.decodeColor("#00DCDC");
        this.charColors[81] = this.charColors[78];
        this.charColors[71] = CharColorSet.decodeColor("#323232");
        this.charColors[76] = CharColorSet.decodeColor("#0F820F");
        this.charColors[86] = this.charColors[76];
        this.charColors[73] = this.charColors[76];
        this.charColors[65] = CharColorSet.decodeColor("#000000");
        this.charColors[87] = CharColorSet.decodeColor("#B45AB4");
        this.charColors[72] = CharColorSet.decodeColor("#8282D2");
        this.charColors[80] = CharColorSet.decodeColor("#DC9682");
        for (c = '\u0000'; c < '\u0080'; c = (char)((char)(c + 1))) {
            if (this.charColors[c] == null) continue;
            String string = "" + c;
            String string2 = string.toLowerCase();
            this.charColors[string2.charAt((int)0)] = this.charColors[c];
        }
    }

    public void copyStateFrom(CharColorSet charColorSet) {
        this.setMissing(charColorSet.getMissing());
        this.setEmpty(charColorSet.getEmpty());
        this.setName(charColorSet.getName());
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.missing = CharColorSet.decodeColor(configNode.getAttribute("missing", this.default_missingColor));
        this.empty = CharColorSet.decodeColor(configNode.getAttribute("empty", this.default_emptyColor));
        this.name = configNode.getAttribute("name", this.default_name);
    }

    public String toString() {
        return "CharColorSet " + this.getName() + "\n" + "missing: " + this.getMissing().toString() + "\t" + "empty: " + this.getEmpty().toString() + "\t";
    }

    public Color getMissing() {
        return this.missing;
    }

    public Color getEmpty() {
        return this.empty;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor(char c) {
        Color color = null;
        if (c < '\u0080') {
            color = this.charColors[c];
        } else {
            System.out.println("passed in char " + c + " greater than maxChar " + 128 + " to CharColorSet.java");
        }
        if (color == null) {
            return this.getMissing();
        }
        return color;
    }

    public void setMissing(String string) {
        this.missing = CharColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("missing", string, this.default_missingColor);
        }
    }

    public void setEmpty(String string) {
        this.empty = CharColorSet.decodeColor(string);
        if (this.root != null) {
            this.root.setAttribute("empty", string, this.default_emptyColor);
        }
    }

    public void setColor(char c, String string) {
    }

    public void setMissing(Color color) {
        this.missing = color;
        if (this.root != null) {
            this.root.setAttribute("missing", CharColorSet.encodeColor(this.missing), this.default_missingColor);
        }
    }

    public void setEmpty(Color color) {
        this.empty = color;
        if (this.root != null) {
            this.root.setAttribute("empty", CharColorSet.encodeColor(this.empty), this.default_emptyColor);
        }
    }

    public void setColor(char c, Color color) {
    }

    public void setName(String string) {
        this.name = string;
        if (this.root != null) {
            this.root.setAttribute("name", string, this.default_name);
        }
    }

    public static final Color decodeColor(String string) {
        return ColorSet.decodeColor(string);
    }

    public static final String encodeColor(Color color) {
        return ColorSet.encodeColor(color);
    }
}

