/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.ContrastSelectable;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;
import java.awt.Color;
import java.util.Observable;

public class ColorExtractor
extends Observable
implements ConfigNodePersistent,
ContrastSelectable {
    private ColorSet defaultColorSet;
    private double default_contrast = 3.0;
    private final ColorSet colorSet = new ColorSet();
    private boolean m_logTranform = false;
    private double m_logCenter = 1.0;
    private double m_logBaseDivisor;
    private double m_logBase;
    private ConfigNode root;
    private double contrast = this.default_contrast;
    private double nodata;
    private double empty;
    private final float[] upColor = new float[3];
    private final float[] zeroColor = new float[3];
    private final float[] downColor = new float[3];
    private final float[] missingColor = new float[3];
    private final float[] emptyColor = new float[3];

    public ColorExtractor() {
        this.defaultColorSet = new ColorSet();
        this.defaultColorSet.setUp(ColorSet.decodeColor("#FF0000"));
        this.defaultColorSet.setZero(ColorSet.decodeColor("#000000"));
        this.defaultColorSet.setDown(ColorSet.decodeColor("#00FF00"));
        this.defaultColorSet.setMissing(ColorSet.decodeColor("#909090"));
        this.defaultColorSet.setEmpty(ColorSet.decodeColor("#FFFFFF"));
        this.setDefaultColorSet(this.defaultColorSet);
        this.setLogBase(2.0);
    }

    public void setDefaultColorSet(ColorSet colorSet) {
        this.defaultColorSet = colorSet;
    }

    public void bindConfig(ConfigNode configNode) {
        if (this.root != configNode) {
            this.root = configNode;
            ConfigNode configNode2 = this.root.fetchFirst("ColorSet");
            if (configNode2 == null) {
                configNode2 = this.root.create("ColorSet");
            }
            this.colorSet.bindConfig(configNode2);
            this.synchFloats();
            this.contrast = this.root.getAttribute("contrast", this.getContrast());
            this.setLogCenter(this.root.getAttribute("logcenter", 1.0));
            this.setLogBase(this.root.getAttribute("logbase", 2.0));
            this.m_logTranform = this.root.getAttribute("logtransform", 0) == 1;
            this.setChanged();
        }
    }

    public void setContrast(double d) {
        if (this.contrast != d) {
            this.contrast = d;
            if (this.root != null) {
                this.root.setAttribute("contrast", this.contrast, this.default_contrast);
            }
            this.setChanged();
        }
    }

    public void setLogTransform(boolean bl) {
        if (bl != this.m_logTranform) {
            this.m_logTranform = bl;
            if (this.root != null) {
                this.root.setAttribute("logtransform", bl ? 1 : 0, 0);
            }
            this.setChanged();
        }
    }

    public void setLogCenter(double d) {
        if (this.m_logCenter != d) {
            this.m_logCenter = d;
            if (this.root != null) {
                this.root.setAttribute("logcenter", d, 1.0);
            }
            this.setChanged();
        }
    }

    public double getLogCenter() {
        return this.m_logCenter;
    }

    public void setLogBase(double d) {
        if (this.m_logBase != d) {
            this.m_logBase = d;
            this.m_logBaseDivisor = Math.log(d);
            if (this.root != null) {
                this.root.setAttribute("logbase", d, 2.0);
            }
            this.setChanged();
        }
    }

    public double getLogBase() {
        return this.m_logBase;
    }

    public boolean getLogTransform() {
        return this.m_logTranform;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setMissing(double d, double d2) {
        this.nodata = d;
        this.empty = d2;
        this.setChanged();
    }

    public Color getUp() {
        return this.colorSet.getUp();
    }

    public Color getZero() {
        return this.colorSet.getZero();
    }

    public Color getDown() {
        return this.colorSet.getDown();
    }

    public Color getMissing() {
        return this.colorSet.getMissing();
    }

    public Color getEmpty() {
        return this.colorSet.getEmpty();
    }

    private void synchFloats() {
        this.synchFloats(this.colorSet.getUp(), this.upColor);
        this.synchFloats(this.colorSet.getZero(), this.zeroColor);
        this.synchFloats(this.colorSet.getDown(), this.downColor);
        this.synchFloats(this.colorSet.getMissing(), this.missingColor);
        this.synchFloats(this.colorSet.getEmpty(), this.emptyColor);
    }

    private void synchFloats(Color color, float[] fArray) {
        fArray[0] = (float)color.getRed() / 256.0f;
        fArray[1] = (float)color.getGreen() / 256.0f;
        fArray[2] = (float)color.getBlue() / 256.0f;
    }

    public void setUpColor(String string) {
        if (ColorSet.encodeColor(this.colorSet.getUp()).equals(string)) {
            return;
        }
        this.colorSet.setUp(ColorSet.decodeColor(string));
        this.synchFloats(this.colorSet.getUp(), this.upColor);
        this.setChanged();
    }

    public void setZeroColor(String string) {
        if (ColorSet.encodeColor(this.colorSet.getZero()).equals(string)) {
            return;
        }
        this.colorSet.setZero(ColorSet.decodeColor(string));
        this.synchFloats(this.colorSet.getZero(), this.zeroColor);
        this.setChanged();
    }

    public void setDownColor(String string) {
        if (ColorSet.encodeColor(this.colorSet.getDown()).equals(string)) {
            return;
        }
        this.colorSet.setDown(ColorSet.decodeColor(string));
        this.synchFloats(this.colorSet.getDown(), this.downColor);
        this.setChanged();
    }

    public void setMissingColor(String string) {
        if (ColorSet.encodeColor(this.colorSet.getMissing()).equals(string)) {
            return;
        }
        this.colorSet.setMissing(ColorSet.decodeColor(string));
        this.synchFloats(this.colorSet.getMissing(), this.missingColor);
        this.setChanged();
    }

    public void setEmptyColor(String string) {
        if (string == null) {
            return;
        }
        if (ColorSet.encodeColor(this.colorSet.getEmpty()).equals(string)) {
            return;
        }
        this.colorSet.setEmpty(ColorSet.decodeColor(string));
        this.synchFloats(this.colorSet.getEmpty(), this.emptyColor);
        this.setChanged();
    }

    public void setUpColor(Color color) {
        if (this.colorSet.getUp().equals(color)) {
            return;
        }
        this.colorSet.setUp(color);
        this.synchFloats(this.colorSet.getUp(), this.upColor);
        this.setChanged();
    }

    public void setZeroColor(Color color) {
        if (this.colorSet.getZero().equals(color)) {
            return;
        }
        this.colorSet.setZero(color);
        this.synchFloats(this.colorSet.getZero(), this.zeroColor);
        this.setChanged();
    }

    public void setDownColor(Color color) {
        if (this.colorSet.getDown().equals(color)) {
            return;
        }
        this.colorSet.setDown(color);
        this.synchFloats(this.colorSet.getDown(), this.downColor);
        this.setChanged();
    }

    public void setMissingColor(Color color) {
        if (this.colorSet.getMissing().equals(color)) {
            return;
        }
        this.colorSet.setMissing(color);
        this.synchFloats(this.colorSet.getMissing(), this.missingColor);
        this.setChanged();
    }

    public void setEmptyColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.colorSet.getEmpty().equals(color)) {
            return;
        }
        this.colorSet.setEmpty(color);
        this.synchFloats(this.colorSet.getEmpty(), this.emptyColor);
        this.setChanged();
    }

    public Color getColor(double d) {
        float[] fArray = this.getFloatColor(d);
        Color color = new Color(fArray[0], fArray[1], fArray[2]);
        return color;
    }

    public float[] getFloatColor(double d) {
        double d2;
        if (d == this.nodata) {
            return this.missingColor;
        }
        if (d == this.empty) {
            return this.emptyColor;
        }
        if (this.m_logTranform) {
            d = Math.log(d / this.m_logCenter) / this.m_logBaseDivisor;
        }
        if ((d2 = d < 0.0 ? -d / this.contrast : d / this.contrast) > 1.0) {
            d2 = 1.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        float f = (float)d2;
        float f2 = (float)(1.0 - d2);
        float[] fArray = new float[3];
        if (d < 0.0) {
            for (int i = 0; i < 3; ++i) {
                fArray[i] = this.downColor[i] * f + this.zeroColor[i] * f2;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                fArray[i] = this.upColor[i] * f + this.zeroColor[i] * f2;
            }
        }
        return fArray;
    }

    public void printSelf() {
        System.out.println("upColor " + this.upColor[0] + ", " + this.upColor[1] + ", " + this.upColor[2]);
        System.out.println("downColor " + this.downColor[0] + ", " + this.downColor[1] + ", " + this.downColor[2]);
        System.out.println("zeroColor " + this.zeroColor[0] + ", " + this.zeroColor[1] + ", " + this.zeroColor[2]);
        System.out.println("missingColor " + this.missingColor[0] + ", " + this.missingColor[1] + ", " + this.missingColor[2]);
        System.out.println("emptyColor " + this.emptyColor[0] + ", " + this.emptyColor[1] + ", " + this.emptyColor[2]);
    }

    public int getARGBColor(double d) {
        float[] fArray = this.getFloatColor(d);
        return 0xFF000000 | (int)(255.0f * fArray[0]) << 16 | (int)(255.0f * fArray[1]) << 8 | (int)(255.0f * fArray[2]);
    }

    public void setDefaults() {
        this.setUpColor(ColorSet.encodeColor(this.defaultColorSet.getUp()));
        this.setZeroColor(ColorSet.encodeColor(this.defaultColorSet.getZero()));
        this.setDownColor(ColorSet.encodeColor(this.defaultColorSet.getDown()));
        this.setMissingColor(ColorSet.encodeColor(this.defaultColorSet.getMissing()));
        this.setEmptyColor(ColorSet.encodeColor(this.defaultColorSet.getEmpty()));
        this.setContrast(this.default_contrast);
        this.synchFloats();
        this.setChanged();
    }
}

