/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorSet;

public class ColorPresets
implements ConfigNodePersistent {
    private ConfigNode root;
    private static final int dIndex = 0;
    public static ColorSet[] defaultColorSets = new ColorSet[2];

    public ColorPresets(ConfigNode configNode) {
        this.bindConfig(configNode);
        int n = this.getPresetNames().length;
        if (n == 0) {
            this.addDefaultPresets();
        }
    }

    public ColorPresets() {
        this.root = new DummyConfigNode("ColorPresets");
    }

    public int getDefaultIndex() {
        return this.root.getAttribute("default", 0);
    }

    public boolean isDefaultEnabled() {
        return this.getDefaultIndex() != -1;
    }

    public ColorSet getDefaultColorSet() {
        int n = this.getDefaultIndex();
        try {
            return this.getColorSet(n);
        }
        catch (Exception exception) {
            return this.getColorSet(0);
        }
    }

    public void setDefaultIndex(int n) {
        this.root.setAttribute("default", n, 0);
    }

    public void addDefaultPresets() {
        for (int i = 0; i < defaultColorSets.length; ++i) {
            this.addColorSet(defaultColorSets[i]);
        }
    }

    public String[] getPresetNames() {
        ConfigNode[] configNodeArray = this.root.fetch("ColorSet");
        String[] stringArray = new String[configNodeArray.length];
        ColorSet colorSet = new ColorSet();
        for (int i = 0; i < configNodeArray.length; ++i) {
            colorSet.bindConfig(configNodeArray[i]);
            stringArray[i] = colorSet.getName();
        }
        return stringArray;
    }

    public int getNumPresets() {
        ConfigNode[] configNodeArray = this.root.fetch("ColorSet");
        return configNodeArray.length;
    }

    public String toString() {
        ConfigNode[] configNodeArray = this.root.fetch("ColorSet");
        ColorSet colorSet = new ColorSet();
        String[] stringArray = this.getPresetNames();
        String string = "No Presets";
        if (stringArray.length > 0) {
            string = "Default is " + stringArray[this.getDefaultIndex()] + " index " + this.getDefaultIndex() + "\n";
        }
        for (int i = 0; i < configNodeArray.length; ++i) {
            colorSet.bindConfig(configNodeArray[i]);
            string = string + colorSet.toString() + "\n";
        }
        return string;
    }

    public ColorSet getColorSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("ColorSet");
        try {
            ColorSet colorSet = new ColorSet();
            colorSet.bindConfig(configNodeArray[n]);
            return colorSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ColorSet getColorSet(String string) {
        ConfigNode[] configNodeArray = this.root.fetch("ColorSet");
        ColorSet colorSet = new ColorSet();
        for (int i = 0; i < configNodeArray.length; ++i) {
            colorSet.bindConfig(configNodeArray[i]);
            if (!string.equals(colorSet.getName())) continue;
            return colorSet;
        }
        return null;
    }

    public void addColorSet(String string, String string2, String string3, String string4, String string5) {
        ColorSet colorSet = new ColorSet();
        colorSet.bindConfig(this.root.create("ColorSet"));
        colorSet.setName(string);
        colorSet.setUp(string2);
        colorSet.setZero(string3);
        colorSet.setDown(string4);
        colorSet.setMissing(string5);
    }

    public void addColorSet(ColorSet colorSet) {
        ColorSet colorSet2 = new ColorSet();
        if (this.root != null) {
            colorSet2.bindConfig(this.root.create("ColorSet"));
        }
        colorSet2.copyStateFrom(colorSet);
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        int n = this.getPresetNames().length;
        if (n == 0) {
            this.addDefaultPresets();
        }
    }

    public void removeColorSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("ColorSet");
        this.root.remove(configNodeArray[n]);
    }

    private ConfigNode createSubNode() {
        return this.root.create("ColorSet");
    }

    static {
        ColorPresets.defaultColorSets[0] = new ColorSet("RedGreen", "#FF0000", "#000000", "#00FF00", "#909090", "#FFFFFF");
        ColorPresets.defaultColorSets[1] = new ColorSet("YellowBlue", "#FEFF00", "#000000", "#1BB7E5", "#909090", "#FFFFFF");
    }
}

