/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.PluginFactory;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SettingsPanelHolder;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.core.PluginManager;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresetEditor;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.DendroView;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class DendrogramFactory
extends PluginFactory {
    private static ColorPresets colorPresets = new ColorPresets();
    private ColorPresetEditor cpresetEditor = new ColorPresetEditor(colorPresets);
    private JFrame cpresetFrame = null;

    public String getPluginName() {
        return "Dendrogram";
    }

    public MainPanel restorePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        DendroView dendroView = new DendroView(viewFrame.getDataModel(), configNode, viewFrame);
        dendroView.setName("Dendrogram");
        return dendroView;
    }

    public void setGlobalNode(ConfigNode configNode) {
        super.setGlobalNode(configNode);
        colorPresets.bindConfig(configNode.fetchOrCreate("ColorPresets"));
        if (colorPresets.getNumPresets() == 0) {
            colorPresets.addDefaultPresets();
        }
        this.cpresetEditor.synchronizeFrom();
    }

    public void addPluginConfig(TreeviewMenuBarI treeviewMenuBarI, final ViewFrame viewFrame) {
        super.addPluginConfig(treeviewMenuBarI, viewFrame);
        treeviewMenuBarI.addMenuItem("Dendrogram Color Presets...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DendrogramFactory.this.cpresetFrame == null) {
                    DendrogramFactory.this.cpresetFrame = new JFrame("Dendrogram Color Presets");
                    SettingsPanelHolder settingsPanelHolder = new SettingsPanelHolder((Window)DendrogramFactory.this.cpresetFrame, viewFrame.getApp().getGlobalConfig().getRoot());
                    settingsPanelHolder.addSettingsPanel((SettingsPanel)DendrogramFactory.this.cpresetEditor);
                    DendrogramFactory.this.cpresetFrame.getContentPane().add((Component)settingsPanelHolder);
                }
                DendrogramFactory.this.cpresetFrame.pack();
                DendrogramFactory.this.cpresetFrame.show();
            }
        });
        treeviewMenuBarI.setMnemonic(68);
    }

    public SettingsPanel getPresetEditor() {
        return this.cpresetEditor;
    }

    public static ColorPresets getColorPresets() {
        return colorPresets;
    }

    public boolean configurePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        return true;
    }

    static {
        PluginManager.registerPlugin((PluginFactory)new DendrogramFactory());
    }
}

