/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.DummyHeaderInfo;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.NatField;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.UrlExtractor;
import edu.stanford.genetics.treeview.UrlPresets;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelectable;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelector;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.TextView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FUOptionsPanel
extends JPanel
implements SettingsPanel {
    private FontSelectable fontSelectable;
    private UrlExtractor urlExtractor;
    private UrlPresets urlPresets = null;
    private UrlPanel urlPanel = null;
    private HeaderInfo headerInfo;
    private JFrame top;
    private JDialog d;
    private Window window;
    private JPanel innerPanel;
    public static final String[] styles = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};

    public FUOptionsPanel(FontSelectable fontSelectable, UrlExtractor urlExtractor, UrlPresets urlPresets, HeaderInfo headerInfo) {
        this.fontSelectable = fontSelectable;
        this.urlExtractor = urlExtractor;
        this.urlPresets = urlPresets;
        this.headerInfo = headerInfo;
        this.innerPanel = new JPanel();
        this.add(this.innerPanel);
        this.setupWidgets();
    }

    public String getTitle() {
        return "Font and Url Options";
    }

    public static void main(String[] stringArray) {
        UrlPresets urlPresets = new UrlPresets((ConfigNode)new DummyConfigNode("UrlPresets"));
        DummyHeaderInfo dummyHeaderInfo = new DummyHeaderInfo();
        UrlExtractor urlExtractor = new UrlExtractor((HeaderInfo)dummyHeaderInfo);
        TextView textView = new TextView((HeaderInfo)dummyHeaderInfo, urlExtractor);
        textView.setPoints(10);
        FUOptionsPanel fUOptionsPanel = new FUOptionsPanel(textView, urlExtractor, urlPresets, (HeaderInfo)dummyHeaderInfo);
        Frame frame = new Frame(fUOptionsPanel.getTitle());
        frame.add(fUOptionsPanel);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }

    public void synchronizeFrom() {
        this.setupWidgets();
    }

    public void synchronizeTo() {
    }

    private void setupWidgets() {
        this.innerPanel.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.innerPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.innerPanel.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        this.innerPanel.add((Component)new JLabel("Font:", 2), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.innerPanel.add(Box.createVerticalStrut(20), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        EnablePanel enablePanel = new EnablePanel();
        this.innerPanel.add((Component)enablePanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        this.innerPanel.add((Component)new FontSettingsPanel(this.fontSelectable), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.urlPanel = new UrlPanel(this.urlExtractor, this.urlPresets, this.headerInfo);
        this.urlPanel.setEnabled(enablePanel.isSelected());
        this.innerPanel.add((Component)this.urlPanel, gridBagConstraints);
    }

    public void makeTop() {
        this.top = new JFrame(this.getTitle());
        this.top.add(this);
        this.top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        this.top.pack();
        this.top.show();
    }

    public static final String decode_style(int n) {
        switch (n) {
            case 0: {
                return styles[0];
            }
            case 2: {
                return styles[1];
            }
            case 1: {
                return styles[2];
            }
        }
        return styles[3];
    }

    public static final int encode_style(String string) {
        return string == styles[0] ? 0 : (string == styles[1] ? 2 : (string == styles[2] ? 1 : 3));
    }

    public void showDialog(Frame frame, String string) {
        this.d = new JDialog(frame, string);
        this.window = this.d;
        this.d.setLayout(new BorderLayout());
        this.d.add((Component)this, "Center");
        this.d.add((Component)new ButtonPanel(), "South");
        this.d.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().dispose();
            }
        });
        this.d.pack();
        this.d.show();
    }

    public void showDialog(Frame frame) {
        this.showDialog(frame, this.getTitle());
    }

    private class ButtonPanel
    extends JPanel {
        ButtonPanel() {
            JButton jButton = new JButton("Close");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FUOptionsPanel.this.window.hide();
                }
            });
            this.add(jButton);
        }
    }

    class FontPanel
    extends JPanel {
        private String[] fonts = FontSelector.fonts;
        private JComboBox font_choice;
        private JComboBox style_choice;
        private NatField size_field;
        private JButton display_button;
        private FontSelectable client;
        private JLabel exampleField;
        String size_prop;
        String face_prop;
        String style_prop;

        FontPanel(FontSelectable fontSelectable) {
            this.client = fontSelectable;
            this.setupWidgets();
            this.updateExample();
        }

        private void setupFontChoice() {
            this.font_choice = new JComboBox<String>(this.fonts);
            this.font_choice.setSelectedItem(this.client.getFace());
        }

        private void setupStyleChoice() {
            this.style_choice = new JComboBox<String>(styles);
            this.style_choice.setSelectedItem(FUOptionsPanel.decode_style(this.client.getStyle()));
        }

        private void synchronizeClient() {
            String string = (String)this.font_choice.getSelectedItem();
            int n = FUOptionsPanel.encode_style((String)this.style_choice.getSelectedItem());
            int n2 = this.size_field.getNat();
            this.client.setFace(string);
            this.client.setStyle(n);
            this.client.setPoints(n2);
        }

        private void setupWidgets() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this.setupFontChoice();
            this.add((Component)this.font_choice, gridBagConstraints);
            this.setupStyleChoice();
            gridBagConstraints.gridx = 1;
            this.add((Component)this.style_choice, gridBagConstraints);
            this.size_field = new NatField(this.client.getPoints(), 3);
            gridBagConstraints.gridx = 2;
            this.add((Component)this.size_field, gridBagConstraints);
            this.display_button = new JButton("Display");
            this.display_button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontPanel.this.updateExample();
                    FontPanel.this.synchronizeClient();
                }
            });
            gridBagConstraints.gridx = 3;
            this.add((Component)this.display_button, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            this.exampleField = new JLabel("Example Text", 0);
            this.add((Component)this.exampleField, gridBagConstraints);
        }

        private void updateExample() {
            String string = (String)this.font_choice.getSelectedItem();
            int n = FUOptionsPanel.encode_style((String)this.style_choice.getSelectedItem());
            int n2 = this.size_field.getNat();
            this.exampleField.setFont(new Font(string, n, n2));
            this.exampleField.revalidate();
            this.exampleField.repaint();
        }
    }

    class UrlPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private UrlExtractor extractor;
        private UrlPresets presets;
        private HeaderInfo headerInfo;
        private String tester = "YAL039W";
        private JButton[] buttons;
        private JTextField previewField;
        private TemplateField templateField;
        private HeaderChoice headerChoice;
        private GridBagConstraints gbc;

        public void setEnabled(boolean bl) {
            this.templateField.setEnabled(bl);
            this.headerChoice.setEnabled(bl);
            this.previewField.setEnabled(bl);
            for (int i = 0; i < this.buttons.length; ++i) {
                if (this.buttons[i] == null) continue;
                this.buttons[i].setEnabled(bl);
            }
        }

        public UrlPanel(UrlExtractor urlExtractor, UrlPresets urlPresets, HeaderInfo headerInfo) {
            this.extractor = urlExtractor;
            this.presets = urlPresets;
            this.headerInfo = headerInfo;
            this.redoLayout();
            this.templateField.setText(this.extractor.getUrlTemplate());
            try {
                this.headerChoice.setSelectedIndex(this.extractor.getIndex());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.updatePreview();
        }

        public void redoLayout() {
            String[] stringArray = this.presets.getPresetNames();
            int n = stringArray.length;
            this.removeAll();
            this.setLayout(new GridBagLayout());
            this.gbc = new GridBagConstraints();
            this.gbc.gridwidth = 1;
            this.gbc.fill = 2;
            this.gbc.anchor = 11;
            this.gbc.gridy = 0;
            this.gbc.weightx = 100.0;
            this.templateField = new TemplateField();
            this.add((Component)this.templateField, this.gbc);
            this.gbc.gridx = 1;
            this.headerChoice = new HeaderChoice();
            this.gbc.fill = 0;
            this.gbc.weightx = 0.0;
            this.add((Component)this.headerChoice, this.gbc);
            this.gbc.gridx = 0;
            this.gbc.gridy = 1;
            this.gbc.gridwidth = 2;
            this.gbc.fill = 2;
            this.previewField = new JTextField(this.extractor.substitute(this.tester));
            this.previewField.setEditable(false);
            this.add((Component)this.previewField, this.gbc);
            JPanel jPanel = new JPanel();
            this.buttons = new JButton[n];
            int n2 = 0;
            while (n2 < n) {
                JButton jButton = new JButton(this.presets.getPresetNames()[n2]);
                final int n3 = n2++;
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        UrlPanel.this.templateField.setText(UrlPanel.this.presets.getTemplate(n3));
                        UrlPanel.this.updatePreview();
                    }
                });
                jPanel.add(jButton);
                this.buttons[n3] = jButton;
            }
            this.gbc.gridy = 2;
            this.gbc.fill = 1;
            this.gbc.weighty = 100.0;
            this.gbc.weightx = 100.0;
            this.add((Component)jPanel, this.gbc);
        }

        private void updatePreview() {
            this.extractor.setUrlTemplate(this.templateField.getText());
            this.extractor.setIndex(this.headerChoice.getSelectedIndex());
            this.previewField.setText("Ex: " + this.extractor.getUrl(0));
        }

        private void setupPreview() {
            this.previewField = new JTextField("Ex: " + this.extractor.getUrl(0));
            this.previewField.setEditable(false);
        }

        private void setupHeader() {
            this.headerChoice = new HeaderChoice();
        }

        private void addPreset(int n) {
            final int n2 = n;
            this.gbc.gridx = 0;
            this.add((Component)new JLabel(this.presets.getPresetNames()[n2]), this.gbc);
            this.gbc.gridx = 1;
            this.gbc.weightx = 100.0;
            this.add((Component)new JTextField(this.presets.getTemplate(n2)), this.gbc);
            this.gbc.gridx = 2;
            this.gbc.weightx = 0.0;
            JButton jButton = new JButton("Set");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UrlPanel.this.templateField.setText(UrlPanel.this.presets.getTemplate(n2));
                    UrlPanel.this.updatePreview();
                }
            });
            this.add((Component)jButton, this.gbc);
        }

        private class TemplateField
        extends JTextField {
            TemplateField() {
                super("enter url template");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        UrlPanel.this.updatePreview();
                    }
                });
            }
        }

        private class HeaderChoice
        extends JComboBox
        implements ItemListener {
            HeaderChoice() {
                int n;
                String[] stringArray;
                if (UrlPanel.this.headerInfo != null) {
                    stringArray = UrlPanel.this.headerInfo.getNames();
                    n = stringArray.length;
                    if (UrlPanel.this.headerInfo.getIndex("GWEIGHT") != -1) {
                        --n;
                    }
                } else {
                    stringArray = new String[]{"Dummy1", "Dummy2", "Dummy3"};
                    n = stringArray.length;
                }
                for (int i = 0; i < n; ++i) {
                    if (stringArray[i] == null) {
                        this.addItem("-- NULL --");
                        continue;
                    }
                    this.addItem(stringArray[i]);
                }
                this.addItemListener(this);
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                UrlPanel.this.updatePreview();
            }
        }
    }

    class EnablePanel
    extends JPanel {
        JCheckBox enableBox;

        EnablePanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Web Link:", 2), "North");
            this.enableBox = new JCheckBox("Enable", FUOptionsPanel.this.urlExtractor.isEnabled());
            this.enableBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FUOptionsPanel.this.urlExtractor.setEnabled(EnablePanel.this.enableBox.isSelected());
                    FUOptionsPanel.this.urlPanel.setEnabled(EnablePanel.this.enableBox.isSelected());
                }
            });
            this.add((Component)this.enableBox, "Center");
        }

        public boolean isSelected() {
            return this.enableBox.isSelected();
        }
    }
}

