/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.plugin.dendroview.IntegerMap;

public class FixedMap
extends IntegerMap {
    private double default_scale = 10.0;
    private double scale;

    public void bindConfig(ConfigNode configNode) {
        super.bindConfig(configNode);
        this.scale = this.root.getAttribute("scale", this.default_scale);
    }

    public int getIndex(int n) {
        return (int)((double)n / this.scale) + this.minindex;
    }

    public int getPixel(int n) {
        return (int)((double)(n - this.minindex) * this.scale);
    }

    public double getScale() {
        return this.scale;
    }

    public int getUsedPixels() {
        if (this.minindex == -1) {
            return 0;
        }
        int n = (int)((double)(this.maxindex - this.minindex + 1) * this.scale);
        int n2 = (int)(this.scale * (double)((int)((double)this.availablepixels / this.scale)));
        if (n > n2) {
            return n2;
        }
        return n;
    }

    public int getViewableIndexes() {
        int n = (int)((double)this.availablepixels / this.scale);
        return n;
    }

    public void setDefaultScale(double d) {
        this.default_scale = d;
    }

    public void setScale(double d) {
        this.scale = d;
        this.root.setAttribute("scale", this.scale, this.default_scale);
    }

    public String type() {
        return "Fixed";
    }
}

