/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.ModelViewBuffered;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;

public class GTRView
extends ModelViewBuffered
implements MouseListener,
KeyListener {
    private static final String[] hints = new String[]{"Click to select node", " - use arrow keys to navigate tree"};
    protected HeaderSummary headerSummary = new HeaderSummary();
    private TreeSelectionI geneSelection;
    private LinearTransformation xScaleEq;
    private LinearTransformation yScaleEq;
    private MapContainer map;
    private LeftTreeDrawer drawer = null;
    private TreeDrawerNode selectedNode = null;
    private Rectangle destRect = null;

    public GTRView() {
        ((ModelView)this).panel = this;
        this.destRect = new Rectangle();
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addKeyListener(this);
    }

    public String[] getHints() {
        return hints;
    }

    public void setLeftTreeDrawer(LeftTreeDrawer leftTreeDrawer) {
        if (this.drawer != null) {
            this.drawer.deleteObserver((Observer)((Object)this));
        }
        this.drawer = leftTreeDrawer;
        this.drawer.addObserver((Observer)((Object)this));
    }

    public void setGeneSelection(TreeSelectionI treeSelectionI) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver((Observer)((Object)this));
        }
        this.geneSelection = treeSelectionI;
        this.geneSelection.addObserver((Observer)((Object)this));
    }

    public void setMap(MapContainer mapContainer) {
        if (this.map != null) {
            this.map.deleteObserver((Observer)((Object)this));
        }
        this.map = mapContainer;
        this.map.addObserver((Observer)((Object)this));
        ((ModelView)this).offscreenValid = false;
        ((Component)((Object)this)).repaint();
    }

    private void synchMap() {
        if (this.selectedNode != null && this.geneSelection != null) {
            int n = (int)this.selectedNode.getLeftLeaf().getIndex();
            int n2 = (int)this.selectedNode.getRightLeaf().getIndex();
            this.geneSelection.deselectAllIndexes();
            this.geneSelection.selectIndexRange(n, n2);
            this.geneSelection.setSelectedNode(this.selectedNode.getId());
            this.geneSelection.notifyObservers();
        }
        if (((ModelView)this).status != null && ((ModelView)this).hasMouse) {
            ((ModelView)this).status.setMessages(this.getStatus());
        }
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void setSelectedNode(TreeDrawerNode treeDrawerNode) {
        if (this.selectedNode == treeDrawerNode) {
            return;
        }
        if (this.getYScaleEq() != null) {
            if (this.selectedNode != null) {
                this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode, false);
            }
            this.selectedNode = treeDrawerNode;
            if (this.selectedNode != null) {
                this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode, true);
            }
        } else {
            this.selectedNode = treeDrawerNode;
        }
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void selectParent() {
        TreeDrawerNode treeDrawerNode = this.selectedNode;
        this.selectedNode = treeDrawerNode.getParent();
        if (this.selectedNode == null) {
            this.selectedNode = treeDrawerNode;
            return;
        }
        treeDrawerNode = treeDrawerNode == this.selectedNode.getLeft() ? this.selectedNode.getRight() : this.selectedNode.getLeft();
        this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, treeDrawerNode, true);
        this.drawer.paintSingle(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode, true);
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void selectRight() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode treeDrawerNode = this.selectedNode;
        this.selectedNode = treeDrawerNode.getRight();
        this.drawer.paintSingle(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, treeDrawerNode, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, treeDrawerNode.getLeft(), false);
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    private void selectLeft() {
        if (this.selectedNode.isLeaf()) {
            return;
        }
        TreeDrawerNode treeDrawerNode = this.selectedNode;
        this.selectedNode = treeDrawerNode.getLeft();
        this.drawer.paintSingle(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, treeDrawerNode, false);
        this.drawer.paintSubtree(this.offscreenGraphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, treeDrawerNode.getRight(), false);
        this.synchMap();
        ((Component)((Object)this)).repaint();
    }

    public void update(Observable observable, Object object) {
        if (observable == this.map) {
            ((ModelView)this).offscreenValid = false;
            ((Component)((Object)this)).repaint();
        } else if (observable == this.drawer) {
            ((ModelView)this).offscreenValid = false;
            ((Component)((Object)this)).repaint();
        } else if (observable == this.geneSelection) {
            TreeDrawerNode treeDrawerNode = null;
            if (this.geneSelection.getNSelectedIndexes() > 0) {
                if (this.geneSelection.getMinIndex() == this.geneSelection.getMaxIndex()) {
                    treeDrawerNode = this.drawer.getLeaf(this.geneSelection.getMinIndex());
                } else if (this.geneSelection.getMinIndex() == this.map.getMinIndex() && this.geneSelection.getMaxIndex() == this.map.getMaxIndex()) {
                    treeDrawerNode = this.drawer.getRootNode();
                }
            }
            if (treeDrawerNode != null && treeDrawerNode.getId() != this.geneSelection.getSelectedNode()) {
                String string = treeDrawerNode.getId();
                this.geneSelection.setSelectedNode(string);
                this.geneSelection.notifyObservers();
            } else {
                this.setSelectedNode(this.drawer.getNodeById(this.geneSelection.getSelectedNode()));
            }
        } else {
            LogBuffer.println((String)(this.viewName() + "Got an update from unknown " + observable));
        }
    }

    public void setZoomMap(MapContainer mapContainer) {
    }

    public String viewName() {
        return "GTRView";
    }

    public String[] getStatus() {
        String[] stringArray;
        if (this.selectedNode != null) {
            if (this.selectedNode.isLeaf()) {
                stringArray = new String[]{"Leaf Node " + this.selectedNode.getId(), "Pos " + this.selectedNode.getCorr()};
            } else {
                int[] nArray = this.getHeaderSummary().getIncluded();
                stringArray = new String[nArray.length * 2];
                HeaderInfo headerInfo = this.getViewFrame().getDataModel().getGtrHeaderInfo();
                String[] stringArray2 = headerInfo.getNames();
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray[2 * i] = stringArray2[nArray[i]] + ":";
                    stringArray[2 * i + 1] = " " + headerInfo.getHeader(headerInfo.getHeaderIndex(this.selectedNode.getId()))[nArray[i]];
                }
            }
        } else {
            stringArray = new String[]{"Select Node to ", "view annotation."};
        }
        return stringArray;
    }

    public void updateBuffer(Graphics graphics) {
        if (((ModelView)this).offscreenChanged) {
            ((ModelView)this).offscreenValid = false;
        }
        if (!((ModelView)this).offscreenValid && this.drawer != null) {
            this.map.setAvailablePixels(((ModelView)this).offscreenSize.height);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, ((ModelView)this).offscreenSize.width, ((ModelView)this).offscreenSize.height);
            graphics.setColor(Color.black);
            this.destRect.setBounds(0, 0, ((ModelView)this).offscreenSize.width, this.map.getUsedPixels());
            this.setXScaleEq(new LinearTransformation(this.drawer.getCorrMin(), (double)this.destRect.x, this.drawer.getCorrMax(), (double)(this.destRect.x + this.destRect.width)));
            this.setYScaleEq(new LinearTransformation((double)this.map.getIndex(this.destRect.y), (double)this.destRect.y, (double)this.map.getIndex(this.destRect.y + this.destRect.height), (double)(this.destRect.y + this.destRect.height)));
            this.drawer.paint(graphics, this.getXScaleEq(), this.getYScaleEq(), this.destRect, this.selectedNode);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.enclosingWindow().isActive()) {
            return;
        }
        if (this.drawer != null && this.getXScaleEq() != null) {
            if (this.drawer == null) {
                LogBuffer.println((String)"GTRView.mouseClicked() : drawer is null");
            }
            if (this.getXScaleEq() == null) {
                LogBuffer.println((String)"GTRView.mouseClicked() : xscaleEq is null");
            }
            this.setSelectedNode(this.drawer.getClosest(this.getYScaleEq().inverseTransform((double)mouseEvent.getY()), this.getXScaleEq().inverseTransform((double)mouseEvent.getX()), this.getXScaleEq().getSlope() / this.getYScaleEq().getSlope()));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.selectedNode == null) {
            return;
        }
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 38: {
                this.selectParent();
                break;
            }
            case 37: {
                if (this.selectedNode.isLeaf()) break;
                this.selectLeft();
                break;
            }
            case 39: {
                if (this.selectedNode.isLeaf()) break;
                this.selectRight();
                break;
            }
            case 40: {
                if (this.selectedNode.isLeaf()) break;
                TreeDrawerNode treeDrawerNode = this.selectedNode.getRight();
                TreeDrawerNode treeDrawerNode2 = this.selectedNode.getLeft();
                if (treeDrawerNode.getRange() > treeDrawerNode2.getRange()) {
                    this.selectRight();
                    break;
                }
                this.selectLeft();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setXScaleEq(LinearTransformation linearTransformation) {
        this.xScaleEq = linearTransformation;
    }

    public LinearTransformation getXScaleEq() {
        return this.xScaleEq;
    }

    public void setYScaleEq(LinearTransformation linearTransformation) {
        this.yScaleEq = linearTransformation;
    }

    public LinearTransformation getYScaleEq() {
        return this.yScaleEq;
    }

    public void scrollToNode(String string) {
        int n;
        TreeDrawerNode treeDrawerNode = this.drawer.getNodeById(string);
        if (treeDrawerNode != null && !this.map.isVisible(n = (int)treeDrawerNode.getIndex())) {
            this.map.scrollToIndex(n);
            this.map.notifyObservers();
        }
    }
}

