/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import com.gurge.amd.GIFEncoder;
import com.gurge.amd.Quantize;
import com.gurge.amd.TestQuantize;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorBarExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class GifColorBarExportPanel
extends ColorBarExportPanel
implements SettingsPanel {
    public GifColorBarExportPanel(ColorExtractor colorExtractor) {
        super(colorExtractor);
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            ColorBarGifWriter colorBarGifWriter = new ColorBarGifWriter();
            colorBarGifWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            LogBuffer.println((String)("GIF ColorBar Export Panel caught exception " + exception));
        }
    }

    protected boolean hasBbox() {
        return false;
    }

    protected String getInitialExtension() {
        return "_colorbar.gif";
    }

    class ColorBarGifWriter {
        ColorBarGifWriter() {
        }

        public void write(OutputStream outputStream) {
            BufferedImage bufferedImage = GifColorBarExportPanel.this.generateImage();
            try {
                int[][] nArray = TestQuantize.getPixels((Image)bufferedImage);
                int[] nArray2 = Quantize.quantizeImage((int[][])nArray, (int)256);
                GIFEncoder gIFEncoder = new GIFEncoder(GifColorBarExportPanel.this.createImage(TestQuantize.makeImage((int[])nArray2, (int[][])nArray)));
                gIFEncoder.Write(outputStream);
            }
            catch (Exception exception) {
                LogBuffer.println((String)("In GifExportPanel.DendroGifWriter() got exception " + exception));
            }
        }
    }
}

