/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import com.gurge.amd.GIFEncoder;
import com.gurge.amd.Quantize;
import com.gurge.amd.TestQuantize;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.dendroview.ArrayDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.ExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.InvertedTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.LeftTreeDrawer;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class GifExportPanel
extends ExportPanel
implements SettingsPanel {
    public GifExportPanel(HeaderInfo headerInfo, HeaderInfo headerInfo2, TreeSelectionI treeSelectionI, TreeSelectionI treeSelectionI2, InvertedTreeDrawer invertedTreeDrawer, LeftTreeDrawer leftTreeDrawer, ArrayDrawer arrayDrawer, MapContainer mapContainer, MapContainer mapContainer2) {
        super(headerInfo, headerInfo2, treeSelectionI, treeSelectionI2, invertedTreeDrawer, leftTreeDrawer, arrayDrawer, mapContainer, mapContainer2, false);
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.getFile()));
            DendroGifWriter dendroGifWriter = new DendroGifWriter();
            dendroGifWriter.write(bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            LogBuffer.println((String)("GIF Export Panel caught exception " + exception));
        }
    }

    protected boolean hasBbox() {
        return false;
    }

    protected String getInitialExtension() {
        return ".gif";
    }

    class DendroGifWriter {
        int extraWidth;
        int extraHeight;

        DendroGifWriter() {
            this.extraWidth = GifExportPanel.this.getBorderPixels();
            this.extraHeight = GifExportPanel.this.getBorderPixels();
        }

        public void write(OutputStream outputStream) {
            Rectangle rectangle = new Rectangle(0, 0, GifExportPanel.this.estimateWidth(), GifExportPanel.this.estimateHeight());
            Image image = GifExportPanel.this.createImage(rectangle.width + this.extraWidth, rectangle.height + this.extraHeight);
            Graphics graphics = image.getGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, rectangle.width + 1 + this.extraWidth, rectangle.height + 1 + this.extraHeight);
            graphics.setColor(Color.black);
            graphics.translate(this.extraHeight / 2, this.extraWidth / 2);
            GifExportPanel.this.drawAll(graphics, 1.0);
            try {
                int[][] nArray = TestQuantize.getPixels((Image)image);
                int[] nArray2 = Quantize.quantizeImage((int[][])nArray, (int)256);
                GIFEncoder gIFEncoder = new GIFEncoder(GifExportPanel.this.createImage(TestQuantize.makeImage((int[])nArray2, (int[][])nArray)));
                gIFEncoder.Write(outputStream);
            }
            catch (Exception exception) {
                LogBuffer.println((String)("In GifExportPanel.DendroGifWriter() got exception " + exception));
            }
        }
    }
}

