/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.ConfigNodePersistent;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.plugin.dendroview.FillMap;
import edu.stanford.genetics.treeview.plugin.dendroview.FixedMap;

public abstract class IntegerMap
implements ConfigNodePersistent {
    protected int availablepixels = 0;
    protected int maxindex = -1;
    protected int minindex = -1;
    protected ConfigNode root = new DummyConfigNode(this.type());

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.root.setAttribute("type", this.type(), null);
    }

    IntegerMap createMap(String string) {
        if (string.equals("Fixed")) {
            return new FixedMap();
        }
        if (string.equals("Fill")) {
            return new FillMap();
        }
        System.out.println(string + " not found");
        return null;
    }

    public int getAvailablePixels() {
        return this.availablepixels;
    }

    public abstract int getIndex(int var1);

    public int getMaxIndex() {
        return this.maxindex;
    }

    public int getMinIndex() {
        return this.minindex;
    }

    public boolean contains(int n) {
        if (n < this.getMinIndex()) {
            return false;
        }
        return n <= this.getMaxIndex();
    }

    public abstract int getPixel(int var1);

    public int getPixel(double d) {
        double d2 = Math.rint(d);
        double d3 = d - d2 + 0.5;
        int n = (int)d2;
        int n2 = (int)((double)this.getPixel(n) * (1.0 - d3) + d3 * (double)this.getPixel(n + 1));
        return n2;
    }

    public int getRequiredPixels() {
        return (int)((double)(this.maxindex - this.minindex + 1) * this.getScale());
    }

    public abstract double getScale();

    public abstract int getUsedPixels();

    public abstract int getViewableIndexes();

    public void setAvailablePixels(int n) {
        this.availablepixels = n;
    }

    public void setIndexRange(int n, int n2) {
        this.minindex = n;
        this.maxindex = n2;
    }

    public abstract String type();
}

