/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorBarExportPanel;
import edu.stanford.genetics.treeview.plugin.dendroview.ColorExtractor;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class PostscriptColorBarExportPanel
extends ColorBarExportPanel
implements SettingsPanel {
    public PostscriptColorBarExportPanel(ColorExtractor colorExtractor) {
        super(colorExtractor);
    }

    public void synchronizeTo() {
        this.save();
    }

    public void synchronizeFrom() {
    }

    public void save() {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.getFile())));
            ColorBarPostscriptWriter colorBarPostscriptWriter = new ColorBarPostscriptWriter();
            colorBarPostscriptWriter.write(printStream);
            printStream.close();
        }
        catch (Exception exception) {
            LogBuffer.println((String)("Postscript ColorBar Export Panel caught exception " + exception));
        }
    }

    protected boolean hasBbox() {
        return true;
    }

    protected String getInitialExtension() {
        return "_colorbar.ps";
    }

    class ColorBarPostscriptWriter {
        ColorBarPostscriptWriter() {
        }

        private void writeHeader(PrintStream printStream) {
            int n = PostscriptColorBarExportPanel.this.estimateWidth();
            int n2 = PostscriptColorBarExportPanel.this.estimateHeight();
            printStream.println("%!PS-Adobe-3.0");
            if (PostscriptColorBarExportPanel.this.includeBbox()) {
                printStream.println("%%BoundingBox: 0 0 " + n + " " + n2);
            }
            printStream.println("%%Creator: ColorBarPostscriptWriter (a Java TreeView Component)");
            printStream.println("%%CreationDate: " + new Date().toString());
            printStream.println("%%Pages: (atend)");
            printStream.println("%%EndComments");
            printStream.println("%%BeginSetup");
            printStream.println("/ln { newpath moveto lineto stroke closepath } bind def");
            printStream.println("/tx { newpath moveto show closepath } bind def");
            printStream.println("/sl { setlinewidth } def");
            printStream.println("/sc { setlinecap } def");
            printStream.println("/sr { setrgbcolor } def");
            printStream.println("/sf { exch findfont exch scalefont setfont } def");
            printStream.println("/tr { translate } def");
            printStream.println("/sp { 1 sc 1 sl 0.0 0.0 0.0 sr 18.00000 13.00000 tr 0.96000 0.98205 scale tr } def");
            printStream.println("/fb {exch dup 0 rlineto exch 0 exch rlineto neg 0 rlineto closepath fill } bind def");
            printStream.println("/consLineTo {1 index 1 index lineto stroke moveto} bind def");
            printStream.println("/snGTR {1 index moveto 1 index exch consLineTo 1 index consLineTo lineto stroke} bind def");
            printStream.println("/snATR {1 index exch moveto 1 index consLineTo 1 index exch consLineTo exch lineto stroke } bind def");
            printStream.println("%%EndSetup");
            printStream.println("%%Page: tree 1");
            printStream.println("%%PageResources: (atend)");
            printStream.println("%%BeginPageSetup");
            printStream.println("/pgsave save def");
            printStream.println("%%EndPageSetup");
        }

        private void writeBoxes(PrintStream printStream) {
            int n = 1;
            int n2 = 1;
            double d = PostscriptColorBarExportPanel.this.getColorExtractor().getContrast();
            int n3 = PostscriptColorBarExportPanel.this.getNumBoxes();
            if (PostscriptColorBarExportPanel.this.drawVertical()) {
                n = (int)(PostscriptColorBarExportPanel.this.getYscale() * (double)n3);
                n2 = (int)PostscriptColorBarExportPanel.this.getXscale();
            } else {
                n2 = (int)(PostscriptColorBarExportPanel.this.getXscale() * (double)n3);
                n = (int)PostscriptColorBarExportPanel.this.getYscale();
            }
            for (int i = 0; i < n3; ++i) {
                double d2;
                double d3;
                double d4;
                double d5;
                double d6 = (double)i * d * 2.0 / ((double)n3 - 1.0) - d;
                Color color = PostscriptColorBarExportPanel.this.getColorExtractor().getColor(d6);
                printStream.println(this.convertColor(color) + " sr");
                if (PostscriptColorBarExportPanel.this.drawVertical()) {
                    d5 = 0.0;
                    d4 = (double)i * PostscriptColorBarExportPanel.this.getYscale();
                    d3 = PostscriptColorBarExportPanel.this.getXscale();
                    d2 = d4 + PostscriptColorBarExportPanel.this.getYscale();
                } else {
                    d5 = (double)i * PostscriptColorBarExportPanel.this.getXscale();
                    d4 = 0.0;
                    d3 = d5 + PostscriptColorBarExportPanel.this.getXscale();
                    d2 = PostscriptColorBarExportPanel.this.getYscale();
                }
                printStream.println((int)d5 + " " + (int)d4 + " moveto");
                int n4 = (int)(d3 - d5);
                int n5 = (int)(d2 - d4);
                printStream.println(n4 + " " + n5 + " fb");
            }
        }

        private void writeNumbers(PrintStream printStream) {
            double d = PostscriptColorBarExportPanel.this.getColorExtractor().getContrast();
            int n = PostscriptColorBarExportPanel.this.getNumBoxes();
            printStream.println("0 0 0 sr");
            printStream.println(" /Courier findfont");
            printStream.println("12 scalefont");
            printStream.println("setfont");
            for (int i = 0; i < n; ++i) {
                int n2;
                double d2 = (double)i * d * 2.0 / ((double)n - 1.0) - d;
                String string = PostscriptColorBarExportPanel.this.formatValue(d2);
                if (PostscriptColorBarExportPanel.this.drawVertical()) {
                    n2 = (int)((double)i * PostscriptColorBarExportPanel.this.getYscale());
                    printStream.println(PostscriptColorBarExportPanel.this.getXscale() + " " + n2 + " moveto");
                    printStream.println("( " + this.psEscape(string) + " ) show");
                    continue;
                }
                n2 = (int)((double)(i + 1) * PostscriptColorBarExportPanel.this.getXscale());
                printStream.println("90 rotate");
                printStream.println(PostscriptColorBarExportPanel.this.getYscale() + " " + -n2 + " moveto");
                printStream.println("( " + this.psEscape(string) + " ) show");
                printStream.println("-90 rotate");
            }
        }

        private String psEscape(String string) {
            String string2 = "()";
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (string2.indexOf(c) >= 0) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        private String convertColor(Color color) {
            return this.convertRGB(color.getRed()) + " " + this.convertRGB(color.getGreen()) + " " + this.convertRGB(color.getBlue());
        }

        private float convertRGB(int n) {
            return (float)n / 255.0f;
        }

        private void writeFooter(PrintStream printStream) {
            printStream.println("showpage");
        }

        public void write(PrintStream printStream) {
            this.writeHeader(printStream);
            this.writeBoxes(printStream);
            this.writeNumbers(printStream);
            this.writeFooter(printStream);
            if (printStream.checkError()) {
                LogBuffer.println((String)"Some error occured during PostScript export");
            }
        }
    }
}

