/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.UrlExtractor;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelectable;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelector;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TreeColorer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class TextView
extends ModelView
implements FontSelectable,
KeyListener,
AdjustmentListener,
MouseListener,
MouseMotionListener {
    private final int scrollstep = 5;
    private final String d_face = "Courier";
    private final int d_style = 0;
    private final int d_size = 12;
    protected HeaderInfo headerInfo = null;
    protected HeaderSummary headerSummary = new HeaderSummary();
    private ConfigNode root = null;
    private String face;
    private int style;
    private int size;
    private TreeSelectionI geneSelection;
    private MapContainer map;
    private UrlExtractor urlExtractor;
    private int maxlength = 0;
    private int col;
    private boolean dragging = false;
    private JScrollPane scrollPane;

    public String[] getHints() {
        String[] stringArray = new String[]{"Click and drag to scroll"};
        return stringArray;
    }

    public TextView(HeaderInfo headerInfo, UrlExtractor urlExtractor) {
        this.urlExtractor = urlExtractor;
        this.headerInfo = headerInfo;
        this.col = -1;
        int n = this.headerInfo.getIndex("GID");
        if (n == -1) {
            this.headerSummary.setIncluded(new int[]{1});
        } else {
            this.headerSummary.setIncluded(new int[]{2});
        }
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        ((Component)((Object)this)).addKeyListener(this);
        this.scrollPane = new JScrollPane((Component)((Object)this));
        this.scrollPane.setBorder(null);
        this.panel = this.scrollPane;
    }

    public TextView(HeaderInfo headerInfo, UrlExtractor urlExtractor, int n) {
        this.urlExtractor = urlExtractor;
        this.headerInfo = headerInfo;
        this.col = n;
        int n2 = this.headerInfo.getIndex("GID");
        if (n2 == -1) {
            this.headerSummary.setIncluded(new int[]{1});
        } else {
            this.headerSummary.setIncluded(new int[]{2});
        }
        ((Component)((Object)this)).addMouseListener(this);
        ((Component)((Object)this)).addMouseMotionListener(this);
        ((Component)((Object)this)).addKeyListener(this);
        this.scrollPane = new JScrollPane((Component)((Object)this));
        this.scrollPane.setBorder(null);
        this.panel = this.scrollPane;
    }

    public String viewName() {
        return "TextView";
    }

    public MenuItem getFontMenuItem() {
        MenuItem menuItem = new MenuItem("Gene Font...");
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontSelector fontSelector = new FontSelector(TextView.this, "Select Fonts for Gene Info");
                fontSelector.showDialog((Frame)TextView.this.viewFrame);
            }
        });
        return menuItem;
    }

    public void updateBuffer(Graphics graphics) {
        this.updateBuffer(graphics, this.offscreenSize);
    }

    public void updateBuffer(Image image) {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        this.updateBuffer(image.getGraphics(), dimension);
    }

    public void updateBuffer(Graphics graphics, Dimension dimension) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        if (this.map.getMinIndex() >= 0 && dimension.height > 0) {
            Object object;
            int n;
            int n2 = this.map.getIndex(0);
            int n3 = this.map.getIndex(this.map.getUsedPixels());
            graphics.setFont(new Font(this.face, this.style, this.size));
            FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(graphics.getFont());
            int n4 = fontMetrics.getAscent();
            int n5 = this.headerInfo.getIndex("BGCOLOR");
            if (n5 > 0) {
                Color color = graphics.getColor();
                for (n = n2; n < n3; ++n) {
                    if (this.geneSelection != null && !this.geneSelection.isIndexSelected(n)) continue;
                    object = this.headerInfo.getHeader(n);
                    try {
                        graphics.setColor(TreeColorer.getColor(object[n5]));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    graphics.fillRect(0, this.map.getMiddlePixel(n) - n4 / 2, dimension.width, n4);
                }
                graphics.setColor(color);
            }
            int n6 = this.headerInfo.getIndex("FGCOLOR");
            for (n = n2; n < n3; ++n) {
                Object object2;
                object = null;
                if (this.col == -1) {
                    object = this.headerSummary.getSummary(this.headerInfo, n);
                } else {
                    object2 = this.headerSummary.getSummaryArray(this.headerInfo, n);
                    if (object2 != null && this.col < ((String[])object2).length) {
                        object = object2[this.col];
                    }
                }
                if (object == null) continue;
                object2 = graphics.getColor();
                if (this.geneSelection == null || this.geneSelection.isIndexSelected(n)) {
                    String[] stringArray = this.headerInfo.getHeader(n);
                    if (n6 > 0) {
                        graphics.setColor(TreeColorer.getColor(stringArray[n6]));
                    }
                    graphics.drawString((String)object, 0, this.map.getMiddlePixel(n) + n4 / 2);
                    if (n6 <= 0) continue;
                    graphics.setColor((Color)object2);
                    continue;
                }
                graphics.setColor(Color.gray);
                graphics.drawString((String)object, 0, this.map.getMiddlePixel(n) + n4 / 2);
                graphics.setColor((Color)object2);
            }
        }
    }

    public void setGeneSelection(TreeSelectionI treeSelectionI) {
        if (this.geneSelection != null) {
            this.geneSelection.deleteObserver((Observer)((Object)this));
        }
        this.geneSelection = treeSelectionI;
        this.geneSelection.addObserver((Observer)((Object)this));
    }

    public void setMap(MapContainer mapContainer) {
        if (this.map != null) {
            this.map.deleteObserver((Observer)((Object)this));
        }
        this.map = mapContainer;
        if (this.map != null) {
            this.map.addObserver((Observer)((Object)this));
        }
    }

    private void selectionChanged() {
        this.maxlength = 1;
        FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(new Font(this.face, this.style, this.size));
        int n = this.map.getIndex(0);
        int n2 = this.map.getIndex(this.map.getUsedPixels());
        for (int i = n; i < n2; ++i) {
            int n3;
            int n4 = i;
            String string = this.headerSummary.getSummary(this.headerInfo, n4);
            if (string == null || this.maxlength >= (n3 = fontMetrics.stringWidth(string))) continue;
            this.maxlength = n3;
        }
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(this.maxlength, this.map.getUsedPixels()));
        ((JComponent)((Object)this)).revalidate();
        ((Component)((Object)this)).repaint();
    }

    public UrlExtractor getUrlExtractor() {
        return this.urlExtractor;
    }

    public void update(Observable observable, Object object) {
        if (observable == this.map) {
            this.selectionChanged();
        } else if (observable == this.geneSelection) {
            this.selectionChanged();
        } else if (observable == this.headerSummary) {
            this.selectionChanged();
        } else {
            System.out.println("Textview got funny update!");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.urlExtractor == null) {
            return;
        }
        this.urlExtractor.setEnabled(true);
        if (!this.urlExtractor.isEnabled()) {
            return;
        }
        int n = this.map.getIndex(mouseEvent.getY());
        if (this.map.contains(n)) {
            if (this.col != -1) {
                this.viewFrame.displayURL(this.urlExtractor.getUrl(n, this.headerInfo.getNames()[this.col]));
            } else {
                this.viewFrame.displayURL(this.urlExtractor.getUrl(n));
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragging = true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragging) {
            // empty if block
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = 0;
        int n2 = keyEvent.getKeyCode();
        switch (n2) {
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 37: {
                n -= 5;
                break;
            }
            case 39: {
                n += 5;
                break;
            }
            default: {
                return;
            }
        }
        this.adjustScrollbar(n);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.offscreenValid = false;
        ((Component)((Object)this)).repaint();
    }

    private void adjustScrollbar(int n) {
        this.offscreenValid = false;
        ((Component)((Object)this)).repaint();
    }

    public String getFace() {
        return this.face;
    }

    public int getPoints() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public void setFace(String string) {
        if (this.face == null || !this.face.equals(string)) {
            this.face = string;
            if (this.root != null) {
                this.root.setAttribute("face", this.face, "Courier");
            }
            ((JComponent)((Object)this)).setFont(new Font(this.face, this.style, this.size));
            ((Component)((Object)this)).repaint();
        }
    }

    public void setPoints(int n) {
        if (this.size != n) {
            this.size = n;
            if (this.root != null) {
                this.root.setAttribute("size", this.size, 12);
            }
            ((JComponent)((Object)this)).setFont(new Font(this.face, this.style, this.size));
            ((Component)((Object)this)).repaint();
        }
    }

    public void setStyle(int n) {
        if (this.style != n) {
            this.style = n;
            if (this.root != null) {
                this.root.setAttribute("style", this.style, 0);
            }
            ((JComponent)((Object)this)).setFont(new Font(this.face, this.style, this.size));
            ((Component)((Object)this)).repaint();
        }
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        this.setFace(this.root.getAttribute("face", "Courier"));
        this.setStyle(this.root.getAttribute("style", 0));
        this.setPoints(this.root.getAttribute("size", 12));
        this.getHeaderSummary().bindConfig(this.root.fetchOrCreate("GeneSummary"));
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }
}

