/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.HeaderSummary;
import edu.stanford.genetics.treeview.MessagePanel;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.UrlExtractor;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.plugin.dendroview.FontSelectable;
import edu.stanford.genetics.treeview.plugin.dendroview.MapContainer;
import edu.stanford.genetics.treeview.plugin.dendroview.TextView;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class TextViewManager
extends ModelView
implements FontSelectable,
PropertyChangeListener {
    boolean ignoreDividerChange = false;
    UrlExtractor uExtractor;
    JSplitPane last;
    Component root;
    JSplitPane firstNotShown;
    TextView lastView;
    int numViews;
    int numShown;
    HeaderInfo hI;
    Vector textViews;
    ConfigNode configRoot;
    HeaderSummary headerSummary = new HeaderSummary();
    int[] dividerLocations;

    public TextViewManager(HeaderInfo headerInfo, UrlExtractor urlExtractor) {
        this.hI = headerInfo;
        this.uExtractor = urlExtractor;
        this.root = null;
        this.textViews = new Vector();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout());
        this.dividerLocations = new int[headerInfo.getNumNames() - 1];
        this.firstNotShown = null;
        this.numShown = 0;
        int n = headerInfo.getIndex("GID");
        if (n == -1) {
            this.headerSummary.setIncluded(new int[]{1});
        } else {
            this.headerSummary.setIncluded(new int[]{2});
        }
        this.headerSummary.addObserver((Observer)((Object)this));
        this.makeTextViews(headerInfo.getNumNames());
        for (int i = 0; i < this.numViews - 1; ++i) {
            this.dividerLocations[i] = 50;
        }
        this.addTextViews(1);
        this.loadDividerLocations();
        ((JComponent)((Object)this)).setVisible(true);
    }

    private void loadSelection() {
        if (this.configRoot == null) {
            return;
        }
        ConfigNode[] configNodeArray = this.configRoot.fetch("Selection");
        if (configNodeArray.length > 0) {
            int[] nArray = new int[configNodeArray.length];
            for (int i = 0; i < configNodeArray.length; ++i) {
                nArray[i] = configNodeArray[i].getAttribute("index", -1);
            }
            this.headerSummary.setIncluded(nArray);
        }
    }

    private void saveSelection() {
        if (this.configRoot == null) {
            return;
        }
        this.configRoot.removeAll("Selection");
        for (int i = 0; i < this.headerSummary.getIncluded().length; ++i) {
            this.configRoot.create("Selection").setAttribute("index", this.headerSummary.getIncluded()[i], -1);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.headerSummary) {
            this.saveSelection();
            this.saveDividerLocations();
            this.addTextViews(this.headerSummary.getIncluded().length);
            this.loadDividerLocations();
        }
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).update(observable, object);
        }
    }

    public void updateBuffer(Graphics graphics) {
        ((Component)((Object)this)).paintAll(graphics);
    }

    public void updateBuffer(Image image) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).updateBuffer(image);
        }
    }

    public String viewName() {
        return "TextViewManager";
    }

    public void setViewFrame(ViewFrame viewFrame) {
        super.setViewFrame(viewFrame);
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setViewFrame(viewFrame);
        }
    }

    public void setHintPanel(MessagePanel messagePanel) {
        super.setHintPanel(messagePanel);
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setHintPanel(messagePanel);
        }
    }

    public void setStatusPanel(MessagePanel messagePanel) {
        super.setStatusPanel(messagePanel);
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setStatusPanel(messagePanel);
        }
    }

    private void makeTextViews(int n) {
        this.numViews = n;
        for (int i = 0; i < n; ++i) {
            this.textViews.add(new TextView(this.hI, this.uExtractor, i));
            ((TextView)this.textViews.lastElement()).setHeaderSummary(this.headerSummary);
            this.headerSummary.addObserver((Observer)((Object)((TextView)this.textViews.lastElement())));
        }
    }

    private void addTextViews(int n) {
        this.numShown = n;
        if (n <= 0) {
            return;
        }
        if (n == 1) {
            this.root = ((TextView)this.textViews.get(0)).getComponent();
        } else {
            this.root = new JSplitPane(1);
            ((JSplitPane)this.root).setDividerSize(2);
            ((JSplitPane)this.root).setBorder(null);
            ((JSplitPane)this.root).setRightComponent(((TextView)this.textViews.get(n - 1)).getComponent());
            ((JSplitPane)this.root).setLeftComponent(((TextView)this.textViews.get(n - 2)).getComponent());
            this.root.addPropertyChangeListener("dividerLocation", this);
            for (int i = n - 3; i >= 0; --i) {
                JSplitPane jSplitPane = new JSplitPane(1);
                jSplitPane.setLeftComponent(((TextView)this.textViews.get(i)).getComponent());
                jSplitPane.setRightComponent(this.root);
                jSplitPane.setDividerSize(2);
                jSplitPane.setBorder(null);
                jSplitPane.addPropertyChangeListener("dividerLocation", this);
                this.root = jSplitPane;
            }
        }
        this.panel.removeAll();
        this.panel.add(this.root);
        this.panel.updateUI();
    }

    public void setGeneSelection(TreeSelectionI treeSelectionI) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setGeneSelection(treeSelectionI);
        }
    }

    public void setMap(MapContainer mapContainer) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setMap(mapContainer);
        }
    }

    public void bindConfig(ConfigNode configNode) {
        int n;
        this.configRoot = configNode;
        this.loadSelection();
        ConfigNode[] configNodeArray = this.configRoot.fetch("TextView");
        for (n = configNodeArray.length; n < this.textViews.size(); ++n) {
            this.configRoot.create("TextView");
        }
        configNodeArray = this.configRoot.fetch("TextView");
        for (n = 0; n < this.textViews.size(); ++n) {
            ((TextView)this.textViews.get(n)).bindConfig(configNodeArray[n]);
        }
        if (this.textViews.size() > 0) {
            ((JComponent)((Object)this)).setFont(((Component)((Object)((TextView)this.textViews.firstElement()))).getFont());
        }
        this.loadDividerLocationsFromConfig();
        this.loadDividerLocations();
    }

    public String getFace() {
        return ((Component)((Object)this)).getFont().getName();
    }

    public int getPoints() {
        return ((Component)((Object)this)).getFont().getSize();
    }

    public int getStyle() {
        return ((Component)((Object)this)).getFont().getStyle();
    }

    public void setFace(String string) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setFace(string);
        }
        if (this.textViews.size() > 0) {
            ((JComponent)((Object)this)).setFont(((Component)((Object)((TextView)this.textViews.firstElement()))).getFont());
        }
        ((Component)((Object)this)).repaint();
    }

    public void setPoints(int n) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setPoints(n);
        }
        if (this.textViews.size() > 0) {
            ((JComponent)((Object)this)).setFont(((Component)((Object)((TextView)this.textViews.firstElement()))).getFont());
        }
        ((Component)((Object)this)).repaint();
    }

    public void setStyle(int n) {
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setStyle(n);
        }
        if (this.textViews.size() > 0) {
            ((JComponent)((Object)this)).setFont(((Component)((Object)((TextView)this.textViews.firstElement()))).getFont());
        }
        ((Component)((Object)this)).repaint();
    }

    public void setHeaderSummary(HeaderSummary headerSummary) {
        this.headerSummary = headerSummary;
        for (int i = 0; i < this.textViews.size(); ++i) {
            ((TextView)this.textViews.get(i)).setHeaderSummary(headerSummary);
        }
    }

    public HeaderSummary getHeaderSummary() {
        return this.headerSummary;
    }

    public void saveDividerLocationsToConfig() {
        ConfigNode configNode = null;
        if (this.configRoot != null) {
            configNode = this.configRoot.fetchFirst("Dividers");
            if (configNode == null) {
                configNode = this.configRoot.create("Dividers");
            }
        } else {
            return;
        }
        for (int i = 0; i < this.numViews - 1; ++i) {
            if (configNode == null) continue;
            configNode.setAttribute("Position" + i, this.dividerLocations[i], -1);
        }
    }

    public void saveDividerLocations() {
        Component component = this.panel.getComponent(0);
        for (int i = 0; i < this.numShown - 1; ++i) {
            this.dividerLocations[i] = ((JSplitPane)component).getDividerLocation();
            component = ((JSplitPane)component).getRightComponent();
        }
    }

    public void loadDividerLocationsFromConfig() {
        ConfigNode configNode = null;
        if (this.configRoot == null) {
            return;
        }
        configNode = this.configRoot.fetchFirst("Dividers");
        for (int i = 0; i < this.numViews - 1; ++i) {
            if (configNode == null) continue;
            this.dividerLocations[i] = configNode.getAttribute("Position" + i, 50);
        }
    }

    public void loadDividerLocations() {
        this.ignoreDividerChange = true;
        Component component = this.panel.getComponent(0);
        for (int i = 0; i < this.numShown - 1; ++i) {
            ((JSplitPane)component).setDividerLocation(this.dividerLocations[i]);
            component = ((JSplitPane)component).getRightComponent();
        }
        this.ignoreDividerChange = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.ignoreDividerChange && propertyChangeEvent.getPropertyName() == "dividerLocation") {
            this.saveDividerLocations();
            this.saveDividerLocationsToConfig();
        }
    }
}

