/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.dendroview;

import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.TreeDrawerNode;
import java.awt.Color;

public class TreeColorer {
    private static int colorInd;
    private static String[][] headers;
    private static HeaderInfo headerInfo;
    private static String[] colornames;
    private static Color[] colors;

    public static void colorUsingHeader(TreeDrawerNode treeDrawerNode, HeaderInfo headerInfo) {
        int n = headerInfo.getIndex("FGCOLOR");
        if (n < 0) {
            return;
        }
        TreeColorer.colorUsingHeader(treeDrawerNode, headerInfo, n);
    }

    public static final synchronized void colorUsingHeader(TreeDrawerNode treeDrawerNode, HeaderInfo headerInfo, int n) {
        colorInd = n;
        TreeColorer.headerInfo = headerInfo;
        if (TreeColorer.headerInfo == null) {
            LogBuffer.println((String)"TreeColorer: headers null");
            return;
        }
        if (colorInd < 0) {
            LogBuffer.println((String)"TreeColorer: colorInd < 0");
            return;
        }
        if (treeDrawerNode == null) {
            LogBuffer.println((String)"TreeColorer: root null");
            return;
        }
        TreeColorer.recursiveColorUsingHeader(treeDrawerNode);
    }

    private static final void recursiveColorUsingHeader(TreeDrawerNode treeDrawerNode) {
        if (treeDrawerNode.isLeaf()) {
            return;
        }
        int n = headerInfo.getHeaderIndex(treeDrawerNode.getId());
        if (n < 0) {
            LogBuffer.println((String)("Problem finding node " + treeDrawerNode.getId()));
        }
        String[] stringArray = headerInfo.getHeader(n);
        String string = stringArray[colorInd];
        treeDrawerNode.setColor(TreeColorer.parseColor(string));
        TreeColorer.recursiveColorUsingHeader(treeDrawerNode.getLeft());
        TreeColorer.recursiveColorUsingHeader(treeDrawerNode.getRight());
    }

    public static final synchronized void colorUsingLeaf(TreeDrawerNode treeDrawerNode, HeaderInfo headerInfo, int n) {
        colorInd = n;
        TreeColorer.headerInfo = headerInfo;
        if (TreeColorer.headerInfo == null) {
            LogBuffer.println((String)"headers null");
            return;
        }
        if (colorInd < 0) {
            return;
        }
        TreeColorer.recursiveColorUsingLeaf(treeDrawerNode);
    }

    public static final synchronized void colorize(TreeDrawerNode treeDrawerNode, String[][] stringArray, int n) {
        colorInd = n;
        headers = stringArray;
        if (headers == null) {
            return;
        }
        if (colorInd < 0) {
            return;
        }
        TreeColorer.recursiveColor(treeDrawerNode);
    }

    private static final void recursiveColorUsingLeaf(TreeDrawerNode treeDrawerNode) {
        if (treeDrawerNode.isLeaf()) {
            treeDrawerNode.setColor(TreeColorer.parseColor(headerInfo.getHeader((int)treeDrawerNode.getIndex(), colorInd)));
        } else {
            TreeColorer.recursiveColorUsingLeaf(treeDrawerNode.getLeft());
            TreeColorer.recursiveColorUsingLeaf(treeDrawerNode.getRight());
            TreeColorer.majorityColor(treeDrawerNode);
        }
    }

    private static final void recursiveColor(TreeDrawerNode treeDrawerNode) {
        if (treeDrawerNode.isLeaf()) {
            treeDrawerNode.setColor(TreeColorer.parseColor(headers[(int)treeDrawerNode.getIndex()][colorInd]));
        } else {
            TreeColorer.recursiveColor(treeDrawerNode.getLeft());
            TreeColorer.recursiveColor(treeDrawerNode.getRight());
            TreeColorer.majorityColor(treeDrawerNode);
        }
    }

    private static final void majorityColor(TreeDrawerNode treeDrawerNode) {
        int n;
        int[] nArray = new int[100];
        int n2 = (int)treeDrawerNode.getMinIndex();
        int n3 = (int)treeDrawerNode.getMaxIndex();
        for (n = n2; n < n3; ++n) {
            int n4;
            String string = headers == null ? headerInfo.getHeader(n, colorInd) : headers[n][colorInd];
            int n5 = n4 = TreeColorer.getIndex(string);
            nArray[n5] = nArray[n5] + 1;
        }
        n = 0;
        int n6 = 0;
        while (colornames[n6] != null) {
            if (nArray[n6] > nArray[n]) {
                n = n6;
            }
            ++n6;
        }
        treeDrawerNode.setColor(colors[n]);
    }

    public static Color getColor(String string) {
        return colors[TreeColorer.getIndex(string)];
    }

    private static int getIndex(String string) {
        int n;
        for (n = 0; n < colornames.length && colornames[n] != null; ++n) {
            if (!colornames[n].equals(string)) continue;
            return n;
        }
        TreeColorer.colornames[n] = string;
        TreeColorer.colors[n] = TreeColorer.parseColor(colornames[n]);
        return n;
    }

    private static final Color synthesizeColor(TreeDrawerNode treeDrawerNode, TreeDrawerNode treeDrawerNode2) {
        if (treeDrawerNode.getColor().equals(treeDrawerNode2.getColor())) {
            return treeDrawerNode.getColor();
        }
        return Color.black;
    }

    private static final Color parseColor(String string) {
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            return Color.gray;
        }
    }

    static {
        colornames = new String[100];
        colors = new Color[100];
    }
}

