/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.plugin.karyoview.Chromosome;
import edu.stanford.genetics.treeview.plugin.karyoview.ChromosomeLocus;

class CircularChromosome
extends Chromosome {
    ChromosomeLocus[] circularArm;

    CircularChromosome(int n) {
        this.circularArm = new ChromosomeLocus[n];
    }

    public void insertLocus(ChromosomeLocus chromosomeLocus) {
        if (chromosomeLocus.getArm() == 3) {
            this.insertLocusIntoArray(this.circularArm, chromosomeLocus);
        }
    }

    public double getMaxPosition() {
        return this.circularArm[this.circularArm.length - 1].getPosition();
    }

    public double getMaxPosition(int n) {
        if (n == 3) {
            return this.getMaxPosition();
        }
        return 0.0;
    }

    public int getType() {
        return 1;
    }

    public ChromosomeLocus getLeftEnd() {
        return this.circularArm[0];
    }

    public ChromosomeLocus getRightEnd() {
        return this.circularArm[this.circularArm.length - 1];
    }

    public ChromosomeLocus getClosestLocus(int n, double d) {
        if (n == 3) {
            return this.getLocusRecursive(d, this.circularArm, 0, this.circularArm.length - 1);
        }
        return null;
    }

    public ChromosomeLocus getLocus(int n, int n2) {
        if (n == 3) {
            return this.circularArm[n2];
        }
        return null;
    }
}

