/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorSet;

public class KaryoColorPresets {
    private ConfigNode root;
    private static final int dIndex = 0;
    public static KaryoColorSet[] defaultColorSets = new KaryoColorSet[2];

    public KaryoColorPresets(ConfigNode configNode) {
        this.bindConfig(configNode);
        int n = this.getPresetNames().length;
        if (n == 0) {
            this.addDefaultPresets();
        }
    }

    public KaryoColorPresets() {
        this((ConfigNode)new DummyConfigNode("KaryoColorPresets"));
    }

    public int getDefaultIndex() {
        return this.root.getAttribute("default", 0);
    }

    public boolean isDefaultEnabled() {
        return this.getDefaultIndex() != -1;
    }

    public KaryoColorSet getDefaultColorSet() {
        int n = this.getDefaultIndex();
        try {
            return this.getColorSet(n);
        }
        catch (Exception exception) {
            return this.getColorSet(0);
        }
    }

    public void setDefaultIndex(int n) {
        this.root.setAttribute("default", n, 0);
    }

    public void addDefaultPresets() {
        for (int i = 0; i < defaultColorSets.length; ++i) {
            this.addColorSet(defaultColorSets[i]);
        }
    }

    public String[] getPresetNames() {
        ConfigNode[] configNodeArray = this.root.fetch("KaryoColorSet");
        String[] stringArray = new String[configNodeArray.length];
        KaryoColorSet karyoColorSet = new KaryoColorSet("TempColorSet");
        for (int i = 0; i < configNodeArray.length; ++i) {
            karyoColorSet.bindConfig(configNodeArray[i]);
            stringArray[i] = karyoColorSet.getName();
        }
        return stringArray;
    }

    public int getNumPresets() {
        ConfigNode[] configNodeArray = this.root.fetch("KaryoColorSet");
        return configNodeArray.length;
    }

    public String toString() {
        ConfigNode[] configNodeArray = this.root.fetch("KaryoColorSet");
        KaryoColorSet karyoColorSet = new KaryoColorSet();
        String string = "Default is " + this.getPresetNames()[this.getDefaultIndex()] + " index " + this.getDefaultIndex() + "\n";
        for (int i = 0; i < configNodeArray.length; ++i) {
            karyoColorSet.bindConfig(configNodeArray[i]);
            string = string + karyoColorSet.toString() + "\n";
        }
        return string;
    }

    public KaryoColorSet getColorSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("KaryoColorSet");
        try {
            KaryoColorSet karyoColorSet = new KaryoColorSet();
            karyoColorSet.bindConfig(configNodeArray[n]);
            return karyoColorSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public KaryoColorSet getColorSet(String string) {
        ConfigNode[] configNodeArray = this.root.fetch("KaryoColorSet");
        KaryoColorSet karyoColorSet = new KaryoColorSet();
        for (int i = 0; i < configNodeArray.length; ++i) {
            karyoColorSet.bindConfig(configNodeArray[i]);
            if (!string.equals(karyoColorSet.getName())) continue;
            return karyoColorSet;
        }
        return null;
    }

    public void addColorSet(KaryoColorSet karyoColorSet) {
        KaryoColorSet karyoColorSet2 = new KaryoColorSet("AddingColorSet");
        karyoColorSet2.bindConfig(this.root.create("KaryoColorSet"));
        karyoColorSet2.copyStateFrom(karyoColorSet);
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        int n = this.getPresetNames().length;
        if (n == 0) {
            this.addDefaultPresets();
        }
    }

    public void removeColorSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("KaryoColorSet");
        this.root.remove(configNodeArray[n]);
    }

    private ConfigNode createSubNode() {
        return this.root.create("KaryoColorSet");
    }

    static {
        KaryoColorPresets.defaultColorSets[0] = new KaryoColorSet("BlackBG", "#FF0000", "#00FF00", "#FFFF00", "#FFFFFF", "#000000", "#A0A0A0");
        KaryoColorPresets.defaultColorSets[1] = new KaryoColorSet("WhiteBG", "#FF0000", "#00FF00", "#FFFF00", "#000000", "#FFFFFF", "#A0A0A0");
    }
}

