/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.TreeSelectionI;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoDrawer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class KaryoExportPanel
extends JPanel {
    private ConfigNode root;
    private FileSet sourceSet;
    private TreeSelectionI geneSelection;
    private KaryoDrawer karyoDrawer;
    private FilePanel filePanel;
    private InclusionPanel inclusionPanel;
    private PreviewPanel previewPanel;

    protected TreeSelectionI getGeneSelection() {
        return this.geneSelection;
    }

    protected KaryoDrawer getKaryoDrawer() {
        return this.karyoDrawer;
    }

    public FileSet getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(FileSet fileSet) {
        this.sourceSet = fileSet;
        if (this.filePanel != null) {
            this.filePanel.setFilePath(this.getInitialFilePath());
        }
    }

    protected boolean hasBbox() {
        return true;
    }

    protected boolean includeBbox() {
        return this.inclusionPanel.useBbox();
    }

    protected File getFile() {
        return this.filePanel.getFile();
    }

    protected String getInitialExtension() {
        return ".ps";
    }

    protected String getInitialFilePath() {
        String string = null;
        string = this.sourceSet == null ? System.getProperty("user.home") : this.sourceSet.getDir() + this.sourceSet.getRoot() + this.getInitialExtension();
        if (this.root == null) {
            return string;
        }
        return this.root.getAttribute("file", string);
    }

    public KaryoExportPanel(TreeSelectionI treeSelectionI, KaryoDrawer karyoDrawer) {
        this.geneSelection = treeSelectionI;
        this.karyoDrawer = karyoDrawer;
        this.setupWidgets();
        this.inclusionPanel.synchSelected();
        this.inclusionPanel.synchEnabled();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public ConfigNode createSubNode() {
        return this.root.create("File");
    }

    private void setupWidgets() {
        Box box = new Box(0);
        this.inclusionPanel = new InclusionPanel();
        box.add(this.inclusionPanel);
        this.previewPanel = new PreviewPanel();
        box.add(this.previewPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)box, "Center");
        this.filePanel = new FilePanel(this.getInitialFilePath());
        this.add((Component)this.filePanel, "South");
    }

    public double getXscale() {
        return this.inclusionPanel.getXscale();
    }

    public double getYscale() {
        return this.inclusionPanel.getYscale();
    }

    public int getBboxWidth() {
        return this.inclusionPanel.getBboxWidth();
    }

    public int getBboxHeight() {
        return this.inclusionPanel.getBboxHeight();
    }

    public int estimateHeight() {
        int n = 0;
        return n;
    }

    public int estimateWidth() {
        int n = 0;
        return n;
    }

    class FilePanel
    extends JPanel {
        private JTextField fileField;

        String getFilePath() {
            return this.fileField.getText();
        }

        File getFile() {
            return new File(this.getFilePath());
        }

        void setFilePath(String string) {
            this.fileField.setText(string);
            this.fileField.invalidate();
            this.fileField.revalidate();
            this.fileField.repaint();
        }

        public FilePanel(String string) {
            this.add(new JLabel("Export To: "));
            this.fileField = new JTextField(string);
            this.add(this.fileField);
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(KaryoExportPanel.this);
                        if (n == 0) {
                            FilePanel.this.fileField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException iOException) {
                        LogBuffer.println((String)("Got exception " + iOException));
                    }
                }
            });
            this.add(jButton);
        }
    }

    class InclusionPanel
    extends JPanel {
        JCheckBox bboxBox;
        JTextField xScaleField;
        JTextField yScaleField;
        BboxRow bboxRow;
        SizeRow sizeRow;
        DocumentListener documentListener = null;

        public boolean useBbox() {
            return this.bboxBox.isSelected();
        }

        public double getXscale() {
            Double d = new Double(this.xScaleField.getText());
            return d;
        }

        public double getYscale() {
            Double d = new Double(this.yScaleField.getText());
            return d;
        }

        public int getBboxWidth() {
            return this.bboxRow.xSize();
        }

        public int getBboxHeight() {
            return this.bboxRow.ySize();
        }

        public void synchEnabled() {
            this.bboxRow.setEnabled(this.bboxBox.isSelected());
            this.updateSize();
            if (KaryoExportPanel.this.previewPanel != null) {
                KaryoExportPanel.this.previewPanel.updatePreview();
            }
        }

        public void synchSelected() {
            this.updateSize();
            if (KaryoExportPanel.this.previewPanel != null) {
                KaryoExportPanel.this.previewPanel.updatePreview();
            }
        }

        public void recalculateBbox() {
            this.bboxRow.setXsize(0);
            this.bboxRow.setYsize(0);
        }

        public void updateSize() {
            try {
                this.sizeRow.setXsize(KaryoExportPanel.this.estimateWidth());
                this.sizeRow.setYsize(KaryoExportPanel.this.estimateHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        InclusionPanel() {
            this.documentListener = new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    InclusionPanel.this.updateSize();
                    if (KaryoExportPanel.this.previewPanel != null) {
                        KaryoExportPanel.this.previewPanel.updatePreview();
                    }
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    InclusionPanel.this.updateSize();
                    if (KaryoExportPanel.this.previewPanel != null) {
                        KaryoExportPanel.this.previewPanel.updatePreview();
                    }
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    InclusionPanel.this.updateSize();
                    if (KaryoExportPanel.this.previewPanel != null) {
                        KaryoExportPanel.this.previewPanel.updatePreview();
                    }
                }
            };
            this.setupWidgets();
            this.recalculateBbox();
        }

        private void setupWidgets() {
            this.setLayout(new BoxLayout(this, 1));
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InclusionPanel.this.synchEnabled();
                }
            };
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Scale:"));
            this.xScaleField = new JTextField(1);
            this.yScaleField = new JTextField(1);
            jPanel.add(this.xScaleField);
            jPanel.add(new JLabel("x"));
            jPanel.add(this.yScaleField);
            this.add(jPanel);
            this.xScaleField.getDocument().addDocumentListener(this.documentListener);
            this.yScaleField.getDocument().addDocumentListener(this.documentListener);
            this.bboxBox = new JCheckBox("Bounding Box?", KaryoExportPanel.this.hasBbox());
            this.bboxBox.addActionListener(actionListener);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(this.bboxBox);
            this.bboxRow = new BboxRow();
            if (KaryoExportPanel.this.hasBbox()) {
                this.add(jPanel2);
                this.add(this.bboxRow);
            }
            this.sizeRow = new SizeRow();
            this.add(this.sizeRow);
        }

        class SizeRow
        extends JPanel {
            JTextField xSize;
            JTextField ySize;

            public SizeRow() {
                this.setupWidgets();
            }

            protected void setupWidgets() {
                this.add(new JLabel("Total Size:"));
                this.xSize = new JTextField("2", 5);
                this.ySize = new JTextField("2", 5);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(inch)"));
            }

            int xSize() {
                Double d = new Double(this.xSize.getText());
                return (int)(d * 72.0);
            }

            void setXsize(int n) {
                this.xSize.setText(this.convert(n));
            }

            void setYsize(int n) {
                this.ySize.setText(this.convert(n));
            }

            private String convert(int n) {
                Double d = new Double(Math.rint((double)n * 100.0 / 72.0) / 100.0);
                return d.toString();
            }

            int ySize() {
                Double d = new Double(this.ySize.getText());
                return (int)(d * 72.0);
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.xSize.setEnabled(bl);
                this.ySize.setEnabled(bl);
            }
        }

        class BboxRow
        extends SizeRow {
            BboxRow() {
            }

            protected void setupWidgets() {
                DocumentListener documentListener = new DocumentListener(){

                    public void changedUpdate(DocumentEvent documentEvent) {
                        InclusionPanel.this.updateSize();
                        if (KaryoExportPanel.this.previewPanel != null) {
                            KaryoExportPanel.this.previewPanel.updatePreview();
                        }
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        InclusionPanel.this.updateSize();
                        if (KaryoExportPanel.this.previewPanel != null) {
                            KaryoExportPanel.this.previewPanel.updatePreview();
                        }
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        InclusionPanel.this.updateSize();
                        if (KaryoExportPanel.this.previewPanel != null) {
                            KaryoExportPanel.this.previewPanel.updatePreview();
                        }
                    }
                };
                this.add(new JLabel("BBox size:"));
                this.xSize = new JTextField("2", 4);
                this.ySize = new JTextField("2", 4);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(inch)"));
                this.xSize.getDocument().addDocumentListener(documentListener);
                this.ySize.getDocument().addDocumentListener(documentListener);
            }
        }
    }

    class PreviewPanel
    extends JPanel {
        JCheckBox drawPreview;

        public void updatePreview() {
            this.repaint();
        }

        PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Preview"), "North");
            this.add((Component)new DrawingPanel(), "Center");
            this.drawPreview = new JCheckBox("Draw Preview");
            this.drawPreview.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreviewPanel.this.updatePreview();
                }
            });
            this.drawPreview.setSelected(true);
            this.add((Component)this.drawPreview, "South");
        }

        class DrawingPanel
        extends JPanel {
            DrawingPanel() {
            }

            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                int n = KaryoExportPanel.this.estimateWidth();
                int n2 = KaryoExportPanel.this.estimateHeight();
                if (n == 0 || n2 == 0) {
                    return;
                }
                if (n * dimension.height > n2 * dimension.width) {
                    n2 = n2 * dimension.width / n;
                    n = dimension.width;
                } else {
                    n = n * dimension.height / n2;
                    n2 = dimension.height;
                }
                if (PreviewPanel.this.drawPreview == null || PreviewPanel.this.drawPreview.isSelected()) {
                    double d = (double)n / (double)KaryoExportPanel.this.estimateWidth();
                } else {
                    graphics.setColor(Color.red);
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    nArray[0] = 0;
                    nArray[1] = 5;
                    nArray[2] = n;
                    nArray[3] = n - 5;
                    nArray2[0] = 5;
                    nArray2[1] = 0;
                    nArray2[2] = n2 - 5;
                    nArray2[3] = n2;
                    graphics.fillPolygon(nArray, nArray2, 4);
                    nArray2[0] = n2 - 5;
                    nArray2[1] = n2;
                    nArray2[2] = 5;
                    nArray2[3] = 0;
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
    }
}

