/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.FileSet;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.plugin.karyoview.Genome;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoDrawer;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class KaryoViewExportPanel
extends JPanel
implements SettingsPanel {
    private ConfigNode root;
    private KaryoView karyoView;
    private FileSet sourceSet;
    private FilePanel filePanel;
    private InclusionPanel inclusionPanel;
    private PreviewPanel previewPanel;
    int inset = 5;

    public FileSet getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(FileSet fileSet) {
        this.sourceSet = fileSet;
        if (this.filePanel != null) {
            this.filePanel.setFilePath(this.getInitialFilePath());
        }
    }

    protected File getFile() {
        return this.filePanel.getFile();
    }

    public String getFilePath() {
        return this.filePanel.getFilePath();
    }

    public void setFilePath(String string) {
        this.filePanel.setFilePath(string);
    }

    protected String getInitialExtension() {
        return ".png";
    }

    protected String getInitialFilePath() {
        String string = null;
        string = this.sourceSet == null ? System.getProperty("user.home") + System.getProperty("file.separator") + "scatterplot" + this.getInitialExtension() : this.sourceSet.getDir() + this.sourceSet.getRoot() + this.getInitialExtension();
        if (this.root == null) {
            return string;
        }
        return this.root.getAttribute("file", string);
    }

    public KaryoViewExportPanel(KaryoView karyoView) {
        this.karyoView = karyoView;
        this.setupWidgets();
        this.inclusionPanel.synchSelected();
        this.inclusionPanel.synchEnabled();
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
    }

    public ConfigNode createSubNode() {
        return this.root.create("File");
    }

    private void setupWidgets() {
        this.inclusionPanel = new InclusionPanel();
        this.previewPanel = new PreviewPanel();
        this.previewPanel.setMinimumSize(new Dimension(100, 100));
        Box box = new Box(0);
        this.inclusionPanel.setAlignmentY(0.5f);
        box.add(this.inclusionPanel);
        this.previewPanel.setAlignmentY(0.5f);
        box.add(this.previewPanel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(box);
        this.filePanel = new FilePanel(this.getInitialFilePath());
        this.add(this.filePanel);
    }

    public int estimateHeight() {
        return this.inclusionPanel.estimateHeight();
    }

    public int estimateWidth() {
        return this.inclusionPanel.estimateWidth();
    }

    protected BufferedImage generateImage() {
        int n;
        int n2 = this.estimateWidth();
        int n3 = this.estimateHeight();
        int[] nArray = this.inclusionPanel.getSelectedChromosomes();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        if (nArray.length == 0) {
            return bufferedImage;
        }
        int n4 = n3 / nArray.length;
        Graphics graphics = bufferedImage.getGraphics();
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        graphics.setClip(rectangle);
        KaryoDrawer karyoDrawer = this.karyoView.getKaryoDrawer();
        Genome genome = karyoDrawer.getGenome();
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = 0;
        rectangle2.y = 0;
        rectangle2.width = n2;
        rectangle2.height = n4;
        for (n = 0; n < nArray.length; ++n) {
            karyoDrawer.paintBackground(bufferedImage.getGraphics(), rectangle2);
            rectangle2.y += n4;
        }
        rectangle2.y = 0;
        for (n = 0; n < nArray.length; ++n) {
            karyoDrawer.paintChromosome(bufferedImage.getGraphics(), genome.getChromosome(nArray[n]), rectangle2);
            rectangle2.y += n4;
        }
        return bufferedImage;
    }

    public abstract /* synthetic */ void synchronizeFrom();

    public abstract /* synthetic */ void synchronizeTo();

    class FilePanel
    extends JPanel {
        private JTextField fileField;

        String getFilePath() {
            return this.fileField.getText();
        }

        File getFile() {
            return new File(this.getFilePath());
        }

        void setFilePath(String string) {
            this.fileField.setText(string);
            this.fileField.invalidate();
            this.fileField.revalidate();
            this.fileField.repaint();
        }

        public FilePanel(String string) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Export To Png: "), "West");
            this.fileField = new JTextField(string);
            this.add((Component)this.fileField, "Center");
            JButton jButton = new JButton("Browse");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser();
                        int n = jFileChooser.showSaveDialog(KaryoViewExportPanel.this);
                        if (n == 0) {
                            FilePanel.this.fileField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException iOException) {
                        LogBuffer.println((String)("Got exception " + iOException));
                    }
                }
            });
            this.add((Component)jButton, "East");
        }
    }

    class InclusionPanel
    extends JPanel {
        JList chrList;

        public void synchEnabled() {
        }

        public void synchSelected() {
        }

        public int[] getSelectedChromosomes() {
            Object[] objectArray = this.chrList.getSelectedValues();
            int[] nArray = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                nArray[i] = (Integer)objectArray[i];
            }
            return nArray;
        }

        public int estimateHeight() {
            int n = ((JComponent)((Object)KaryoViewExportPanel.this.karyoView)).getHeight() / KaryoViewExportPanel.this.karyoView.getKaryoDrawer().getGenome().getMaxChromosome();
            int[] nArray = this.getSelectedChromosomes();
            return (n + 2 * KaryoViewExportPanel.this.inset) * nArray.length;
        }

        public int estimateWidth() {
            int[] nArray = this.getSelectedChromosomes();
            int n = 0;
            KaryoDrawer karyoDrawer = KaryoViewExportPanel.this.karyoView.getKaryoDrawer();
            Genome genome = karyoDrawer.getGenome();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = karyoDrawer.getFarthestEndDistance(genome.getChromosome(nArray[i]));
                if (n2 <= n) continue;
                n = n2;
            }
            return (n + KaryoViewExportPanel.this.inset) * 2;
        }

        InclusionPanel() {
            this.setupWidgets();
        }

        private void setupWidgets() {
            int n;
            this.setLayout(new BoxLayout(this, 1));
            JLabel jLabel = new JLabel("Chromosomes:");
            jLabel.setAlignmentX(0.5f);
            this.add(jLabel);
            int n2 = KaryoViewExportPanel.this.karyoView.getKaryoDrawer().getGenome().getMaxChromosome();
            Integer[] integerArray = new Integer[n2];
            for (n = 0; n < n2; ++n) {
                integerArray[n] = new Integer(n + 1);
            }
            this.chrList = new JList<Integer>(integerArray);
            this.chrList.setAlignmentX(0.5f);
            for (n = 0; n < n2; ++n) {
                if (!KaryoViewExportPanel.this.karyoView.isChromosomeVisible(n + 1)) continue;
                this.chrList.addSelectionInterval(n, n);
            }
            final SizeRow sizeRow = new SizeRow();
            this.chrList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    KaryoViewExportPanel.this.previewPanel.updatePreview();
                    sizeRow.setXsize(InclusionPanel.this.estimateWidth());
                    sizeRow.setYsize(InclusionPanel.this.estimateHeight());
                }
            });
            this.add(this.chrList);
            JLabel jLabel2 = new JLabel("Use shift or alt to select multiple");
            jLabel2.setAlignmentX(0.5f);
            this.add(jLabel2);
            this.add(sizeRow);
        }

        class SizeRow
        extends JPanel {
            JTextField xSize;
            JTextField ySize;

            public SizeRow() {
                this.setupWidgets();
            }

            protected void setupWidgets() {
                this.add(new JLabel("Total Size:"));
                this.xSize = new JTextField("" + InclusionPanel.this.estimateWidth(), 5);
                this.ySize = new JTextField("" + InclusionPanel.this.estimateHeight(), 5);
                this.add(this.xSize);
                this.add(new JLabel("x"));
                this.add(this.ySize);
                this.add(new JLabel("(pixels)"));
            }

            int xSize() {
                Double d = new Double(this.xSize.getText());
                return (int)(d * 72.0);
            }

            void setXsize(int n) {
                this.xSize.setText("" + n);
            }

            void setYsize(int n) {
                this.ySize.setText("" + n);
            }

            private String convert(int n) {
                Double d = new Double(Math.rint((double)n * 100.0 / 72.0) / 100.0);
                return d.toString();
            }

            int ySize() {
                Double d = new Double(this.ySize.getText());
                return (int)(d * 72.0);
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.xSize.setEnabled(bl);
                this.ySize.setEnabled(bl);
            }
        }
    }

    class PreviewPanel
    extends JPanel {
        JCheckBox drawPreview;

        public void updatePreview() {
            this.repaint();
        }

        PreviewPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Preview"), "North");
            this.add((Component)new DrawingPanel(), "Center");
            this.drawPreview = new JCheckBox("Draw Preview");
            this.drawPreview.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PreviewPanel.this.updatePreview();
                }
            });
            if (KaryoViewExportPanel.this.estimateHeight() < 2000 && KaryoViewExportPanel.this.estimateWidth() < 1000) {
                this.drawPreview.setSelected(true);
            } else {
                this.drawPreview.setSelected(false);
            }
            this.add((Component)this.drawPreview, "South");
        }

        class DrawingPanel
        extends JPanel {
            DrawingPanel() {
            }

            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                int n = KaryoViewExportPanel.this.estimateWidth();
                int n2 = KaryoViewExportPanel.this.estimateHeight();
                if (n == 0 || n2 == 0) {
                    return;
                }
                if (n * dimension.height > n2 * dimension.width) {
                    n2 = n2 * dimension.width / n;
                    n = dimension.width;
                } else {
                    n = n * dimension.height / n2;
                    n2 = dimension.height;
                }
                if (PreviewPanel.this.drawPreview == null || PreviewPanel.this.drawPreview.isSelected()) {
                    try {
                        BufferedImage bufferedImage = KaryoViewExportPanel.this.generateImage();
                        graphics.drawImage(bufferedImage, 0, 0, n, n2, Color.white, null);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        JOptionPane.showMessageDialog(this, "Out of memory, Disabling preview");
                        PreviewPanel.this.drawPreview.setSelected(false);
                    }
                } else {
                    graphics.setColor(Color.red);
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    nArray[0] = 0;
                    nArray[1] = 5;
                    nArray[2] = n;
                    nArray[3] = n - 5;
                    nArray2[0] = 5;
                    nArray2[1] = 0;
                    nArray2[2] = n2 - 5;
                    nArray2[3] = n2;
                    graphics.fillPolygon(nArray, nArray2, 4);
                    nArray2[0] = n2 - 5;
                    nArray2[1] = n2;
                    nArray2[2] = 5;
                    nArray2[3] = 0;
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
            }
        }
    }
}

