/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.karyoview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.PluginFactory;
import edu.stanford.genetics.treeview.SettingsPanel;
import edu.stanford.genetics.treeview.SettingsPanelHolder;
import edu.stanford.genetics.treeview.TabbedSettingsPanel;
import edu.stanford.genetics.treeview.TreeviewMenuBarI;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.core.PluginManager;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesPresetEditor;
import edu.stanford.genetics.treeview.plugin.karyoview.CoordinatesPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorPresetEditor;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoColorPresets;
import edu.stanford.genetics.treeview.plugin.karyoview.KaryoPanel;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;

public class KaryoscopeFactory
extends PluginFactory {
    private static KaryoColorPresets colorPresets = new KaryoColorPresets();
    private static CoordinatesPresets coordPresets = new CoordinatesPresets();
    private static KaryoColorPresetEditor cpresetEditor = null;
    private static CoordinatesPresetEditor coordEditor = null;
    private JFrame cpresetFrame = null;
    private TabbedSettingsPanel tabbedPanel;

    public String getPluginName() {
        return "Karyoscope";
    }

    public MainPanel restorePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        KaryoPanel karyoPanel = new KaryoPanel(viewFrame.getDataModel(), viewFrame.getGeneSelection(), viewFrame, configNode);
        ((Component)((Object)karyoPanel)).setName(this.getPluginName());
        return karyoPanel;
    }

    public KaryoscopeFactory() {
        cpresetEditor = new KaryoColorPresetEditor(colorPresets);
        cpresetEditor.setTitle("Karyoscope Color Presets");
        coordEditor = new CoordinatesPresetEditor(coordPresets);
        coordEditor.setTitle("Karyoscope Coordinates Presets");
    }

    public void setGlobalNode(ConfigNode configNode) {
        super.setGlobalNode(configNode);
        colorPresets.bindConfig(configNode.fetchOrCreate("ColorPresets"));
        if (colorPresets.getNumPresets() == 0) {
            colorPresets.addDefaultPresets();
        }
        cpresetEditor.synchronizeFrom();
    }

    public void addPluginConfig(TreeviewMenuBarI treeviewMenuBarI, final ViewFrame viewFrame) {
        super.addPluginConfig(treeviewMenuBarI, viewFrame);
        treeviewMenuBarI.addMenuItem("Karyoscope Color...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (KaryoscopeFactory.this.cpresetFrame == null) {
                    KaryoscopeFactory.this.setupPresetsFrame(viewFrame.getApp().getGlobalConfig().getRoot());
                }
                KaryoscopeFactory.this.tabbedPanel.setSelectedComponent(cpresetEditor);
                ((Component)KaryoscopeFactory.this.cpresetFrame).setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(75);
        if (coordPresets.getNumPresets() == 0) {
            try {
                coordPresets.scanUrl(new URL(viewFrame.getApp().getCodeBase().toString() + "/coordinates"));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            coordEditor.synchronizeFrom();
        }
        treeviewMenuBarI.addMenuItem("Karyoscope Coordinates...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (KaryoscopeFactory.this.cpresetFrame == null) {
                    KaryoscopeFactory.this.setupPresetsFrame(viewFrame.getApp().getGlobalConfig().getRoot());
                }
                KaryoscopeFactory.this.tabbedPanel.setSelectedComponent(coordEditor);
                ((Component)KaryoscopeFactory.this.cpresetFrame).setVisible(true);
            }
        });
        treeviewMenuBarI.setMnemonic(79);
    }

    private void setupPresetsFrame(ConfigNode configNode) {
        this.tabbedPanel = new TabbedSettingsPanel();
        this.tabbedPanel.addSettingsPanel("Color", (SettingsPanel)cpresetEditor);
        this.tabbedPanel.addSettingsPanel("Coordinates", (SettingsPanel)coordEditor);
        this.cpresetFrame = new JFrame("Karyoscope Presets");
        SettingsPanelHolder settingsPanelHolder = new SettingsPanelHolder((Window)this.cpresetFrame, configNode);
        settingsPanelHolder.addSettingsPanel((SettingsPanel)this.tabbedPanel);
        this.cpresetFrame.getContentPane().add((Component)settingsPanelHolder);
        this.cpresetFrame.pack();
    }

    public static KaryoColorPresets getColorPresets() {
        return colorPresets;
    }

    public static CoordinatesPresets getCoordinatesPresets() {
        return coordPresets;
    }

    public static CoordinatesPresetEditor getCoordinatesPresetsEditor() {
        return coordEditor;
    }

    public boolean configurePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        return true;
    }

    static {
        PluginManager.registerPlugin((PluginFactory)new KaryoscopeFactory());
    }
}

