/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.plugin.scatterview.AxisInfo;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorSet;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;

class HorizontalAxisPane
extends JPanel {
    private AxisInfo axisInfo;
    private ScatterColorSet colorSet;
    JLabel titleLabel = new JLabel();

    public void setAxisInfo(AxisInfo axisInfo) {
        this.axisInfo = axisInfo;
        this.titleLabel.setText(axisInfo.getTitle());
        System.out.println("setting label text to " + axisInfo.getTitle());
        this.titleLabel.invalidate();
        this.titleLabel.revalidate();
    }

    public AxisInfo getAxisInfo() {
        return this.axisInfo;
    }

    public void setColorSet(ScatterColorSet scatterColorSet) {
        this.colorSet = scatterColorSet;
    }

    public ScatterColorSet getColorSet() {
        return this.colorSet;
    }

    HorizontalAxisPane(AxisInfo axisInfo, ScatterColorSet scatterColorSet) {
        this.setAxisInfo(axisInfo);
        this.setColorSet(scatterColorSet);
        this.add(this.titleLabel);
    }

    public void paintComponent(Graphics graphics) {
        this.titleLabel.setForeground(this.colorSet.getColor("Axis"));
        this.titleLabel.setBackground(this.colorSet.getColor("Background"));
        Dimension dimension = this.getSize();
        graphics.setColor(this.colorSet.getColor("Background"));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.colorSet.getColor("Axis"));
        graphics.drawLine(0, dimension.height / 2, dimension.width, dimension.height / 2);
    }
}

