/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorSet;

public class ScatterColorPresets {
    private ConfigNode root;
    private static final int dIndex = 0;
    public static ScatterColorSet[] defaultColorSets = new ScatterColorSet[2];

    public ScatterColorPresets(ConfigNode configNode) {
        this.bindConfig(configNode);
        int n = this.getPresetNames().length;
        if (n == 0) {
            this.addDefaultPresets();
        }
    }

    public ScatterColorPresets() {
        this((ConfigNode)new DummyConfigNode("ScatterColorPresets"));
    }

    public int getDefaultIndex() {
        return this.root.getAttribute("default", 0);
    }

    public boolean isDefaultEnabled() {
        return this.getDefaultIndex() != -1;
    }

    public ScatterColorSet getDefaultColorSet() {
        int n = this.getDefaultIndex();
        try {
            return this.getColorSet(n);
        }
        catch (Exception exception) {
            return this.getColorSet(0);
        }
    }

    public void setDefaultIndex(int n) {
        this.root.setAttribute("default", n, 0);
    }

    public void addDefaultPresets() {
        for (int i = 0; i < defaultColorSets.length; ++i) {
            this.addColorSet(defaultColorSets[i]);
        }
    }

    public String[] getPresetNames() {
        ConfigNode[] configNodeArray = this.root.fetch("ScatterColorSet");
        String[] stringArray = new String[configNodeArray.length];
        ScatterColorSet scatterColorSet = new ScatterColorSet("TempColorSet");
        for (int i = 0; i < configNodeArray.length; ++i) {
            scatterColorSet.bindConfig(configNodeArray[i]);
            stringArray[i] = scatterColorSet.getName();
        }
        return stringArray;
    }

    public int getNumPresets() {
        ConfigNode[] configNodeArray = this.root.fetch("ScatterColorSet");
        return configNodeArray.length;
    }

    public String toString() {
        ConfigNode[] configNodeArray = this.root.fetch("ScatterColorSet");
        ScatterColorSet scatterColorSet = new ScatterColorSet();
        String string = "Default is " + this.getPresetNames()[this.getDefaultIndex()] + " index " + this.getDefaultIndex() + "\n";
        for (int i = 0; i < configNodeArray.length; ++i) {
            scatterColorSet.bindConfig(configNodeArray[i]);
            string = string + scatterColorSet.toString() + "\n";
        }
        return string;
    }

    public ScatterColorSet getColorSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("ScatterColorSet");
        try {
            ScatterColorSet scatterColorSet = new ScatterColorSet();
            scatterColorSet.bindConfig(configNodeArray[n]);
            return scatterColorSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ScatterColorSet getColorSet(String string) {
        ConfigNode[] configNodeArray = this.root.fetch("ScatterColorSet");
        ScatterColorSet scatterColorSet = new ScatterColorSet();
        for (int i = 0; i < configNodeArray.length; ++i) {
            scatterColorSet.bindConfig(configNodeArray[i]);
            if (!string.equals(scatterColorSet.getName())) continue;
            return scatterColorSet;
        }
        return null;
    }

    public void addColorSet(ScatterColorSet scatterColorSet) {
        ScatterColorSet scatterColorSet2 = new ScatterColorSet("AddingColorSet");
        if (this.root != null) {
            scatterColorSet2.bindConfig(this.root.create("ScatterColorSet"));
        }
        scatterColorSet2.copyStateFrom(scatterColorSet);
    }

    public void bindConfig(ConfigNode configNode) {
        this.root = configNode;
        int n = this.getPresetNames().length;
        if (n == 0) {
            this.addDefaultPresets();
        }
    }

    public void removeColorSet(int n) {
        ConfigNode[] configNodeArray = this.root.fetch("ScatterColorSet");
        this.root.remove(configNodeArray[n]);
    }

    private ConfigNode createSubNode() {
        return this.root.create("ScatterColorSet");
    }

    static {
        ScatterColorPresets.defaultColorSets[0] = new ScatterColorSet("BlackBG", "#000000", "#00FF00", "#FFFF00", "#FFFFFF");
        ScatterColorPresets.defaultColorSets[1] = new ScatterColorSet("WhiteBG", "#FFFFFF", "#00FF00", "#999900", "#000000");
    }
}

