/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.scatterview;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.DummyConfigNode;
import edu.stanford.genetics.treeview.LinearTransformation;
import edu.stanford.genetics.treeview.LogBuffer;
import edu.stanford.genetics.treeview.ModelView;
import edu.stanford.genetics.treeview.NoValueException;
import edu.stanford.genetics.treeview.RotateImageFilter;
import edu.stanford.genetics.treeview.plugin.scatterview.AxisInfo;
import edu.stanford.genetics.treeview.plugin.scatterview.AxisParameter;
import edu.stanford.genetics.treeview.plugin.scatterview.DragRect;
import edu.stanford.genetics.treeview.plugin.scatterview.DummySource;
import edu.stanford.genetics.treeview.plugin.scatterview.SPDataSource;
import edu.stanford.genetics.treeview.plugin.scatterview.ScatterColorSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class ScatterView
extends ModelView {
    private JScrollPane scrollPane;
    private ScatterColorSet defaultColorSet;
    private final ScatterColorSet colorSet = new ScatterColorSet("ScatterColorSet");
    private ConfigNode configNode = new DummyConfigNode("DefaultScatterView");
    public static final String[] drawStrings = new String[]{"Selected Last", "Selected First", "Row Order"};
    public static final int SELECTED_LAST = 0;
    public static final int SELECTED_FIRST = 1;
    public static final int ROW_ORDER = 2;
    private int defaultDrawSize = 3;
    private int defaultDrawOrder = 0;
    SPDataSource dataSource;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    private JLabel position;
    private boolean justZoomed = false;
    private Point zoomPoint = new Point();
    LinearTransformation xTrans;
    LinearTransformation yTrans;
    AxisInfo xAxisInfo;
    AxisInfo yAxisInfo;
    Dimension offscreenSize = new Dimension();
    int closestPoint = -1;
    int closestDist2 = 1000000;
    int threshold2 = 100;
    protected Image offscreenBuffer = null;
    protected boolean offscreenValid = false;
    private DragRect dragRect = new DragRect();
    private Rectangle calcRect = new Rectangle();
    private Point startPoint = new Point();
    private Point endPoint = new Point();

    public void setDefaultColorSet(ScatterColorSet scatterColorSet) {
        this.defaultColorSet = scatterColorSet;
    }

    public ScatterColorSet getDefaultColorSet() {
        return this.defaultColorSet;
    }

    public void setDefaultColors() {
        this.colorSet.copyStateFrom(this.defaultColorSet);
        ((Component)((Object)this)).repaint();
    }

    public void setColorSet(ScatterColorSet scatterColorSet) {
        this.colorSet.copyStateFrom(scatterColorSet);
    }

    public ScatterColorSet getColorSet() {
        return this.colorSet;
    }

    public void setConfigNode(ConfigNode configNode) {
        this.configNode = configNode;
        if (configNode.fetchFirst("ScatterColorSet") == null) {
            this.getColorSet().bindConfig(this.getFirst("ScatterColorSet"));
            this.setDefaultColors();
        } else {
            this.getColorSet().bindConfig(this.getFirst("ScatterColorSet"));
        }
        this.setupAxisInfo();
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public void setDrawSize(int n) {
        if (this.getDrawSize() == n) {
            return;
        }
        this.offscreenValid = false;
        this.configNode.setAttribute("drawSize", n, this.defaultDrawSize);
    }

    public int getDrawSize() {
        return this.configNode.getAttribute("drawSize", this.defaultDrawSize);
    }

    public void setDrawOrder(int n) {
        if (this.getDrawOrder() == n) {
            return;
        }
        this.offscreenValid = false;
        this.configNode.setAttribute("drawOrder", n, this.defaultDrawOrder);
    }

    public int getDrawOrder() {
        return this.configNode.getAttribute("drawOrder", this.defaultDrawOrder);
    }

    public static final void main(String[] stringArray) {
        DummySource dummySource = new DummySource(271, 137);
        ScatterView scatterView = new ScatterView(dummySource);
        JFrame jFrame = new JFrame("ScatterView Test");
        jFrame.getContentPane().add(scatterView.getComponent());
        ((JComponent)((Object)scatterView)).setToolTipText("test sp");
        scatterView.getComponent().setToolTipText("This Turns Tooltips On");
        ((Component)jFrame).setSize(500, 500);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.show();
    }

    public ScatterView() {
        this(new DummySource(271, 137));
        ((JComponent)((Object)this)).setToolTipText("This Turns Tooltips On");
    }

    public ScatterView(SPDataSource sPDataSource) {
        this(sPDataSource, (ConfigNode)new DummyConfigNode("ScatterViewDummy"));
        ((JComponent)((Object)this)).setToolTipText("This Turns Tooltips On");
    }

    public ScatterView(SPDataSource sPDataSource, ConfigNode configNode) {
        ((Container)((Object)this)).setLayout(null);
        this.setConfigNode(configNode);
        ((JComponent)((Object)this)).setToolTipText("This Turns Tooltips On");
        this.dataSource = sPDataSource;
        int n = this.dataSource.getNumPoints();
        this.setupAxisInfo();
        this.initializeMinMax();
        for (int i = 1; i < n; ++i) {
            try {
                double d = this.dataSource.getX(i);
                double d2 = this.dataSource.getY(i);
                if (d < this.xMin) {
                    this.xMin = d;
                }
                if (d > this.xMax) {
                    this.xMax = d;
                }
                if (d2 < this.yMin) {
                    this.yMin = d2;
                }
                if (!(d2 > this.yMax)) continue;
                this.yMax = d2;
                continue;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        this.defaultColorSet = new ScatterColorSet();
        this.setDefaultColorSet(this.defaultColorSet);
        this.setDefaultColors();
        this.position = new JLabel(this.dataSource.getTitle());
        this.position.setToolTipText("Test postion");
        ((Container)((Object)this)).add(this.position);
        EventTracker eventTracker = new EventTracker();
        ((Component)((Object)this)).addMouseListener(eventTracker);
        ((Component)((Object)this)).addMouseMotionListener(eventTracker);
        ((Component)((Object)this)).addKeyListener(eventTracker);
        this.scrollPane = new JScrollPane((Component)((Object)this));
        this.panel = this.scrollPane;
        this.panel.setToolTipText("Test panel");
    }

    private void setupAxisInfo() {
        AxisInfo axisInfo;
        AxisInfo axisInfo2 = this.getXAxisInfo();
        AxisInfo axisInfo3 = this.getYAxisInfo();
        this.xAxisInfo = null;
        this.yAxisInfo = null;
        ConfigNode[] configNodeArray = this.configNode.fetch("AxisInfo");
        for (int i = 0; i < configNodeArray.length; ++i) {
            axisInfo = new AxisInfo(configNodeArray[i]);
            if (axisInfo.getType().equals("x")) {
                this.setXAxisInfo(axisInfo);
            }
            if (!axisInfo.getType().equals("y")) continue;
            this.setYAxisInfo(axisInfo);
        }
        if (this.getXAxisInfo() == null) {
            ConfigNode configNode = this.configNode.create("AxisInfo");
            axisInfo = new AxisInfo(configNode);
            if (axisInfo2 != null) {
                axisInfo.copyStateFrom(axisInfo2);
            } else {
                axisInfo.setType("x");
            }
            this.setXAxisInfo(axisInfo);
        }
        if (this.getYAxisInfo() == null) {
            AxisInfo axisInfo4 = new AxisInfo(this.configNode.create("AxisInfo"));
            if (axisInfo3 != null) {
                axisInfo4.copyStateFrom(axisInfo3);
            } else {
                axisInfo4.setType("y");
            }
            this.setYAxisInfo(axisInfo4);
        }
        if (this.dataSource != null) {
            this.getXAxisInfo().setTitle(this.dataSource.getXLabel());
            this.getYAxisInfo().setTitle(this.dataSource.getYLabel());
        }
    }

    public void initializeMinMax() {
        int n = this.dataSource.getNumPoints();
        for (int i = 0; i < n; ++i) {
            try {
                this.xMax = this.xMin = this.dataSource.getX(0);
                this.yMax = this.yMin = this.dataSource.getY(0);
                return;
            }
            catch (NoValueException noValueException) {
                continue;
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    private void zoomRectangle(Rectangle rectangle) {
        JViewport jViewport = this.scrollPane.getViewport();
        Dimension dimension = jViewport.getExtentSize();
        double d = (double)dimension.width / (double)rectangle.width;
        double d2 = (double)dimension.height / (double)rectangle.height;
        Dimension dimension2 = new Dimension();
        dimension2.width = (int)((double)((JComponent)((Object)this)).getWidth() * d);
        dimension2.height = (int)((double)((JComponent)((Object)this)).getHeight() * d2);
        ((JComponent)((Object)this)).setPreferredSize(dimension2);
        ((JComponent)((Object)this)).revalidate();
        this.zoomPoint.setLocation((int)(d * (double)rectangle.x), (int)(d2 * (double)rectangle.y));
        this.justZoomed = true;
        this.scrollPane.repaint();
    }

    private void zoomFactor(double d, Point point) {
        JViewport jViewport = this.scrollPane.getViewport();
        Dimension dimension = jViewport.getExtentSize();
        Point point2 = jViewport.getViewPosition();
        if (point == null) {
            point = new Point(point2.x + dimension.width / 2, point2.y + dimension.height / 2);
        }
        Dimension dimension2 = new Dimension();
        dimension2.width = (int)((double)((JComponent)((Object)this)).getWidth() * d);
        dimension2.height = (int)((double)((JComponent)((Object)this)).getHeight() * d);
        ((JComponent)((Object)this)).setPreferredSize(dimension2);
        ((Component)((Object)this)).setSize(dimension2);
        ((Container)((Object)this)).invalidate();
        ((JComponent)((Object)this)).revalidate();
        this.zoomPoint.setLocation((int)((double)point.x * d - (double)(point.x - point2.x)), (int)((double)point.y * d - (double)(point.y - point2.y)));
        this.justZoomed = true;
        this.scrollPane.repaint();
    }

    public String viewName() {
        return "ScatterView";
    }

    public void update(Observable observable, Object object) {
        LogBuffer.println((String)("ScatterView got update from " + observable));
    }

    public void selectionChanged() {
        this.offscreenValid = false;
        ((Component)((Object)this)).repaint();
    }

    private void drawPoint(double d, double d2, Graphics graphics) {
        this.drawPoint((int)d, (int)d2, graphics);
    }

    private void drawPoint(int n, int n2, Graphics graphics) {
        int n3 = (this.getDrawSize() - 1) / 2;
        graphics.drawLine(n - n3, n2, n + n3, n2);
        graphics.drawLine(n, n2 - n3, n, n2 + n3);
    }

    public void setXAxisInfo(AxisInfo axisInfo) {
        this.xAxisInfo = axisInfo;
    }

    public AxisInfo getXAxisInfo() {
        return this.xAxisInfo;
    }

    public void setYAxisInfo(AxisInfo axisInfo) {
        if (!axisInfo.getType().equals("y")) {
            System.out.println("error! wrong type " + axisInfo.getType());
            Exception exception = new Exception();
            exception.printStackTrace();
        }
        this.yAxisInfo = axisInfo;
    }

    public AxisInfo getYAxisInfo() {
        return this.yAxisInfo;
    }

    public Image ensureCapacity(Image image, Dimension dimension) {
        if (image == null) {
            return ((Component)((Object)this)).createImage(dimension.width, dimension.height);
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < dimension.width || n2 < dimension.height) {
            if (n < dimension.width) {
                n = dimension.width;
            }
            if (n2 < dimension.height) {
                n2 = dimension.height;
            }
            Image image2 = ((Component)((Object)this)).createImage(n, n2);
            image2.getGraphics().drawImage(image, 0, 0, null);
            return image2;
        }
        return image;
    }

    public void paintComponent(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        if (dimension == null) {
            return;
        }
        Dimension dimension2 = dimension;
        if (dimension2.width != this.offscreenSize.width || dimension2.height != this.offscreenSize.height) {
            this.offscreenSize.setSize(dimension2);
            this.centerPosition();
        }
        this.updateBuffer(graphics);
    }

    public void drawText(Graphics graphics) {
        Dimension dimension = ((Component)((Object)this)).getSize();
        graphics.setColor(this.colorSet.getColor("Axis"));
        FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(graphics.getFont());
        int n = fontMetrics.getAscent();
        String string = this.dataSource.getXLabel();
        int n2 = fontMetrics.stringWidth(string);
        graphics.drawString(string, (dimension.width - n2) / 2, dimension.height - n / 2);
        string = this.dataSource.getYLabel();
        n2 = fontMetrics.stringWidth(string);
        Image image = ((Component)((Object)this)).createImage(n2 + n / 2, n + n / 2);
        Graphics graphics2 = image.getGraphics();
        graphics2.setColor(this.colorSet.getColor("Background"));
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.setColor(this.colorSet.getColor("Axis"));
        graphics2.drawString(string, n / 2, n);
        image = RotateImageFilter.rotate((Component)((Object)this), (Image)image);
        graphics.drawImage(image, 0, (dimension.height - n2) / 2, null);
    }

    public void recalculateValues() {
        AxisParameter axisParameter = this.getXAxisInfo().getAxisParameter(0);
        AxisParameter axisParameter2 = this.getYAxisInfo().getAxisParameter(0);
        AxisParameter axisParameter3 = this.getXAxisInfo().getAxisParameter(1);
        AxisParameter axisParameter4 = this.getYAxisInfo().getAxisParameter(1);
        if (!axisParameter.getEnabled()) {
            axisParameter.setValue(this.xMin);
        }
        if (!axisParameter2.getEnabled()) {
            axisParameter2.setValue(this.yMin);
        }
        if (!axisParameter3.getEnabled()) {
            axisParameter3.setValue(this.xMax);
        }
        if (!axisParameter4.getEnabled()) {
            axisParameter4.setValue(this.yMax);
        }
    }

    public void updateBuffer(Graphics graphics) {
        if (this.justZoomed) {
            this.justZoomed = false;
            this.scrollPane.getViewport().setViewPosition(this.zoomPoint);
            ((Component)((Object)this)).repaint();
            return;
        }
        Dimension dimension = ((Component)((Object)this)).getSize();
        FontMetrics fontMetrics = ((JComponent)((Object)this)).getFontMetrics(graphics.getFont());
        int n = fontMetrics.getAscent();
        graphics.setColor(this.colorSet.getColor("Background"));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.colorSet.getColor("Axis"));
        this.drawText(graphics);
        this.recalculateValues();
        double d = this.getXAxisInfo().getAxisParameter(0).getValue();
        double d2 = this.getYAxisInfo().getAxisParameter(0).getValue();
        double d3 = this.getXAxisInfo().getAxisParameter(1).getValue();
        double d4 = this.getYAxisInfo().getAxisParameter(1).getValue();
        this.xTrans = new LinearTransformation(d, (double)(3 * n), d3, (double)(dimension.width - 3 * n));
        this.yTrans = new LinearTransformation(d2, (double)(dimension.height - 3 * n), d4, (double)(3 * n));
        switch (this.getDrawOrder()) {
            case 2: {
                int n2 = this.dataSource.getNumPoints();
                Rectangle rectangle = graphics.getClipBounds();
                Point point = new Point();
                for (int i = 0; i < n2; ++i) {
                    try {
                        double d5 = this.dataSource.getX(i);
                        double d6 = this.dataSource.getY(i);
                        point.setLocation((int)this.xTrans.transform(d5), (int)this.yTrans.transform(d6));
                        if (!rectangle.contains(point)) continue;
                        graphics.setColor(this.dataSource.getColor(i));
                        this.drawPoint(point.x, point.y, graphics);
                        continue;
                    }
                    catch (NoValueException noValueException) {
                        // empty catch block
                    }
                }
                break;
            }
            case 1: {
                this.drawSelected(graphics, this.xTrans, this.yTrans);
                this.drawNonselected(graphics, this.xTrans, this.yTrans);
                break;
            }
            case 0: {
                this.drawNonselected(graphics, this.xTrans, this.yTrans);
                this.drawSelected(graphics, this.xTrans, this.yTrans);
            }
        }
        graphics.setColor(this.colorSet.getColor("Axis"));
        graphics.drawRect(n * 2, n * 2, dimension.width - n * 4, dimension.height - n * 4);
        graphics.drawString("" + d4, 0, n * 2);
        graphics.drawString("" + d2, 0, dimension.height - n);
        graphics.drawString("" + d, n, n);
        String string = "" + d3;
        int n3 = fontMetrics.stringWidth(string);
        graphics.drawString(string, dimension.width - n - n3, n);
    }

    public void drawSelected(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2) {
        int n = this.dataSource.getNumPoints();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            if (!this.dataSource.isSelected(i)) continue;
            try {
                double d = this.dataSource.getX(i);
                double d2 = this.dataSource.getY(i);
                point.setLocation((int)linearTransformation.transform(d), (int)linearTransformation2.transform(d2));
                if (!rectangle.contains(point)) continue;
                graphics.setColor(this.dataSource.getColor(i));
                this.drawPoint(point.x, point.y, graphics);
                continue;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
    }

    public void drawNonselected(Graphics graphics, LinearTransformation linearTransformation, LinearTransformation linearTransformation2) {
        int n = this.dataSource.getNumPoints();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = new Point();
        for (int i = 0; i < n; ++i) {
            if (this.dataSource.isSelected(i)) continue;
            try {
                double d = this.dataSource.getX(i);
                double d2 = this.dataSource.getY(i);
                point.setLocation((int)linearTransformation.transform(d), (int)linearTransformation2.transform(d2));
                if (!rectangle.contains(point)) continue;
                graphics.setColor(this.dataSource.getColor(i));
                this.drawPoint(point.x, point.y, graphics);
                continue;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
    }

    public void calculateClosest(Point point) {
        int n = this.dataSource.getNumPoints();
        Point point2 = new Point();
        this.closestPoint = -1;
        for (int i = 0; i < n; ++i) {
            try {
                double d = this.dataSource.getX(i);
                double d2 = this.dataSource.getY(i);
                point2.setLocation((int)this.xTrans.transform(d), (int)this.yTrans.transform(d2));
                int n2 = point2.x - point.x;
                int n3 = point2.y - point.y;
                int n4 = n2 * n2 + n3 * n3;
                if (n4 >= this.closestDist2 && this.closestPoint != -1) continue;
                this.closestPoint = i;
                this.closestDist2 = n4;
                continue;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        this.calculateClosest(this.startPoint);
        if (this.closestDist2 < this.threshold2) {
            try {
                double d = this.dataSource.getX(this.closestPoint);
                double d2 = this.dataSource.getY(this.closestPoint);
                String string = this.dataSource.getLabel(this.closestPoint);
                return string + "\n  (" + d + ", " + d2 + ")";
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        double d = this.xTrans.inverseTransform((double)mouseEvent.getX());
        double d3 = this.yTrans.inverseTransform((double)mouseEvent.getY());
        return "X = " + d + ", " + "Y = " + d3;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        if (this.closestDist2 < this.threshold2) {
            try {
                double d = this.dataSource.getX(this.closestPoint);
                double d2 = this.dataSource.getY(this.closestPoint);
                Point point = new Point();
                point.setLocation((int)this.xTrans.transform(d), (int)this.yTrans.transform(d2));
                return point;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        return null;
    }

    private void centerPosition() {
        this.position.revalidate();
        Dimension dimension = this.position.getPreferredSize();
        this.position.setSize(dimension);
        Dimension dimension2 = ((Component)((Object)this)).getSize();
        JViewport jViewport = this.scrollPane.getViewport();
        Dimension dimension3 = jViewport.getExtentSize();
        Point point = jViewport.getViewPosition();
        this.position.setLocation((dimension2.width - dimension.width) / 2, 0);
        this.position.setLocation(point.x + (dimension3.width - dimension.width) / 2, 0);
        this.position.setForeground(this.colorSet.getColor("Axis"));
        this.position.repaint();
    }

    public void trackMouse(MouseEvent mouseEvent) {
        this.position.revalidate();
        Dimension dimension = this.position.getPreferredSize();
        this.position.setSize(dimension);
        Dimension dimension2 = ((Component)((Object)this)).getSize();
        int n = mouseEvent.getX();
        if (mouseEvent.getX() > dimension2.width / 2) {
            n = mouseEvent.getX() - dimension.width;
        }
        int n2 = mouseEvent.getY();
        if (mouseEvent.getY() > dimension2.height / 2) {
            n2 = mouseEvent.getY() - dimension.height;
        }
        this.position.setLocation(n, n2);
        this.position.repaint();
    }

    public void setOffscreenValid(boolean bl) {
        this.offscreenValid = bl;
    }

    public boolean getOffscreenValid() {
        return this.offscreenValid;
    }

    private ConfigNode getFirst(String string) {
        ConfigNode configNode = this.getConfigNode().fetchFirst(string);
        return configNode == null ? this.getConfigNode().create(string) : configNode;
    }

    class EventTracker
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    ComponentListener {
        private boolean dragging = false;

        EventTracker() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ScatterView.this.startPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            ScatterView.this.endPoint.setLocation(((ScatterView)ScatterView.this).startPoint.x, ((ScatterView)ScatterView.this).startPoint.y);
            ScatterView.this.calcRect.setLocation(((ScatterView)ScatterView.this).startPoint.x, ((ScatterView)ScatterView.this).startPoint.y);
            ScatterView.this.calcRect.setSize(0, 0);
            ScatterView.this.dragRect.setBounds(ScatterView.this.calcRect);
            ScatterView.this.dragRect.setToolTipText("Test dragRect");
            ((Container)((Object)ScatterView.this)).add(ScatterView.this.dragRect);
            ScatterView.this.dragRect.repaint();
            this.dragging = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.dragging = false;
            this.mouseDragged(mouseEvent);
            ((Container)((Object)ScatterView.this)).remove(ScatterView.this.dragRect);
            if (ScatterView.this.xTrans == null) {
                return;
            }
            if (!mouseEvent.isControlDown()) {
                ScatterView.this.dataSource.deselectAll();
            }
            double d = ScatterView.this.xTrans.inverseTransform((double)((ScatterView)ScatterView.this).calcRect.x);
            double d2 = ScatterView.this.xTrans.inverseTransform((double)(((ScatterView)ScatterView.this).calcRect.x + ((ScatterView)ScatterView.this).calcRect.width));
            double d3 = ScatterView.this.yTrans.inverseTransform((double)((ScatterView)ScatterView.this).calcRect.y);
            double d4 = ScatterView.this.yTrans.inverseTransform((double)(((ScatterView)ScatterView.this).calcRect.y + ((ScatterView)ScatterView.this).calcRect.height));
            ScatterView.this.dataSource.select(d, d4, d2, d3);
            ScatterView.this.offscreenValid = false;
            ((Component)((Object)ScatterView.this)).repaint();
        }

        public void componentResized(ComponentEvent componentEvent) {
            ScatterView.this.centerPosition();
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            switch (keyEvent.getKeyChar()) {
                case '-': {
                    ScatterView.this.zoomFactor(0.5, ScatterView.this.startPoint);
                    ((ScatterView)ScatterView.this).startPoint.x = (int)((double)((ScatterView)ScatterView.this).startPoint.x * 0.5);
                    ((ScatterView)ScatterView.this).startPoint.y = (int)((double)((ScatterView)ScatterView.this).startPoint.y * 0.5);
                    this.mouseMoved(new MouseEvent((Component)((Object)ScatterView.this), 503, 10L, 0, ((ScatterView)ScatterView.this).startPoint.x, ((ScatterView)ScatterView.this).startPoint.y, 1, false));
                    break;
                }
                case '+': {
                    ScatterView.this.zoomFactor(2.0, ScatterView.this.startPoint);
                    ((ScatterView)ScatterView.this).startPoint.x = (int)((double)((ScatterView)ScatterView.this).startPoint.x * 2.0);
                    ((ScatterView)ScatterView.this).startPoint.y = (int)((double)((ScatterView)ScatterView.this).startPoint.y * 2.0);
                    this.mouseMoved(new MouseEvent((Component)((Object)ScatterView.this), 503, 10L, 0, ((ScatterView)ScatterView.this).startPoint.x, ((ScatterView)ScatterView.this).startPoint.y, 1, false));
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ScatterView.this.endPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            ScatterView.this.calcRect.setLocation(((ScatterView)ScatterView.this).startPoint.x, ((ScatterView)ScatterView.this).startPoint.y);
            ScatterView.this.calcRect.setSize(0, 0);
            ScatterView.this.calcRect.add(((ScatterView)ScatterView.this).endPoint.x, ((ScatterView)ScatterView.this).endPoint.y);
            if (mouseEvent.isControlDown()) {
                ScatterView.this.dragRect.setColor(Color.white);
            } else {
                ScatterView.this.dragRect.setColor(Color.yellow);
            }
            ScatterView.this.dragRect.setBounds(ScatterView.this.calcRect);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((JComponent)((Object)ScatterView.this)).requestFocus();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ScatterView.this.position.setText(ScatterView.this.dataSource.getTitle());
            ScatterView.this.centerPosition();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (ScatterView.this.xTrans == null) {
                return;
            }
            if (ScatterView.this.yTrans == null) {
                return;
            }
            if (this.dragging) {
                this.mouseDragged(mouseEvent);
            } else {
                ScatterView.this.startPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            }
            ScatterView.this.position.setText(ScatterView.this.getToolTipText(mouseEvent));
            ScatterView.this.centerPosition();
        }
    }
}

