/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.genetics.treeview.plugin.treeanno;

import edu.stanford.genetics.treeview.ConfigNode;
import edu.stanford.genetics.treeview.HeaderInfo;
import edu.stanford.genetics.treeview.MainPanel;
import edu.stanford.genetics.treeview.PluginFactory;
import edu.stanford.genetics.treeview.ViewFrame;
import edu.stanford.genetics.treeview.core.PluginManager;
import edu.stanford.genetics.treeview.plugin.treeanno.TreeAnnoPanel;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class ArrayAnnoFactory
extends PluginFactory {
    public String getPluginName() {
        return "ArrayTreeAnno";
    }

    public MainPanel restorePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        if (!viewFrame.getDataModel().aidFound()) {
            JOptionPane.showMessageDialog((Component)viewFrame, new JTextArea("DataModel does not have array tree"));
            return null;
        }
        HeaderInfo headerInfo = viewFrame.getDataModel().getAtrHeaderInfo();
        headerInfo.addName("NAME", headerInfo.getNumNames());
        headerInfo.addName("ANNOTATION", headerInfo.getNumNames());
        TreeAnnoPanel treeAnnoPanel = new TreeAnnoPanel(viewFrame, configNode);
        treeAnnoPanel.setName(this.getPluginName());
        return treeAnnoPanel;
    }

    public boolean configurePlugin(ConfigNode configNode, ViewFrame viewFrame) {
        configNode.setAttribute("tree_type", 1, 0);
        return true;
    }

    static {
        PluginManager.registerPlugin((PluginFactory)new ArrayAnnoFactory());
    }
}

